// Test des classes FitsBoloRead
/*
set DIR = $PLANCK/Kiruna_2001_01_29/TOI/Full_sampling
ln -sf $DIR/PointingABv8/gLatLonAB_143k05_104000000_108465000.fits pointing.fits
ln -sf $DIR/Bolo_etc/b143k05_104000000_108465000.fits bolo.fits
cmvboloread -L 1000,1 -m 100000 \
           -a gLonBolo_27 -d gLatBolo_27 -b boloMuV_27  -s sampleNum \
           -A pointing.fits -1 0 -B bolo.fits -3 0
*/
#include "sopnamsp.h"
#include "machdefs.h"
#include <typeinfo>
#include <stdio.h>
#include <stdlib.h>
#include <iostream>
// #include <values.h>
#include <string.h>
#include <string>
#include <unistd.h>
#include "sophyainit.h"
#include "pexceptions.h"
#include "fboloread.h"
#include "fabtwriter.h"

//#define NO_VECTOR
#define USE_EXCEPT

int main(int narg,char *arg[])
{
 SophyaInit();
 const char *label_alpha = "", *label_delta = "",
      *label_bolo  = "", *label_flag  = "",
      *label_snum  = "";
 const char *fits_alpha  = "", *fits_delta  = "",
      *fits_bolo   = "", *fits_flag   = "",
      *fits_snum   = "";
 int hdu_alpha=0, hdu_delta=0, hdu_bolo=0, hdu_flag=0, hdu_snum=0;
 long lpmod=1;
 char c;
 while((c = getopt(narg,arg,"ha:d:s:b:f:A:D:S:B:F:1:2:3:4:5:m:")) != -1) {
   switch (c) {
   case 'a' :
     label_alpha = optarg;
     break;
   case 'd' :
     label_delta = optarg;
     break;
   case 'b' :
     label_bolo = optarg;
     break;
   case 'f' :
     label_flag = optarg;
     break;
   case 's' :
     label_snum = optarg;
     break;
   case 'A' :
     fits_alpha = optarg;
     break;
   case 'D' :
     fits_delta = optarg;
     break;
   case 'B' :
     fits_bolo = optarg;
     break;
   case 'F' :
     fits_flag = optarg;
     break;
   case 'S' :
     fits_snum = optarg;
     break;
   case '1' :
     sscanf(optarg,"%d",&hdu_alpha);
     break;
   case '2' :
     sscanf(optarg,"%d",&hdu_delta);
     break;
   case '3' :
     sscanf(optarg,"%d",&hdu_bolo);
     break;
   case '4' :
     sscanf(optarg,"%d",&hdu_flag);
     break;
   case '5' :
     sscanf(optarg,"%d",&hdu_snum);
     break;
   case 'm' :
     sscanf(optarg,"%ld",&lpmod);
     if(lpmod<=0) lpmod = 1;
     break;
   case 'h' :
   default :
     cout<<"cmvcolread   -m print_modulo"
         <<"\n           -a label_alpha -d label_delta"
         <<"\n           -b label_bolo  -f label_flag"
         <<"\n           -s label_snum"
         <<"\n           -A fits_alpha  -D fits_delta"
         <<"\n           -B fits_bolo   -F fits_flag"
         <<"\n           -S fits_snum"
         <<"\n           -1 hdu_alpha  -2 hdu_delta"
         <<"\n           -3 hdu_bolo   -4 hdu_flag"
         <<"\n           -5 hdu_snum"
         <<endl;
     return -1;
   }
 }

 cout<<"alpha: "<<label_alpha<<" ("<<fits_alpha<<") hdu="<<hdu_alpha<<endl;
 cout<<"delta: "<<label_delta<<" ("<<fits_delta<<") hdu="<<hdu_delta<<endl;
 cout<<"bolo : "<<label_bolo <<" ("<<fits_bolo<<") hdu="<<hdu_bolo<<endl;
 cout<<"flag : "<<label_flag <<" ("<<fits_flag<<") hdu="<<hdu_flag<<endl;
 cout<<"snum : "<<label_snum <<" ("<<fits_snum<<") hdu="<<hdu_snum<<endl;

#ifdef USE_EXCEPT
try {
#endif

  FitsBoloRead fbr;
  fbr.SetDebug(3);
  fbr.Print(3);

  if(strlen(label_bolo)>0)
    fbr.SetBolo(label_bolo,fits_bolo,hdu_bolo);
  if(strlen(label_flag)>0)
    fbr.SetFlag(label_flag,fits_flag,hdu_flag);
  if(strlen(label_snum)>0)
    fbr.SetSNum(label_snum,fits_snum,hdu_snum);
  if(strlen(label_alpha)>0)
    fbr.SetAlpha(label_alpha,fits_alpha,hdu_alpha);
  if(strlen(label_delta)>0)
    fbr.SetDelta(label_delta,fits_delta,hdu_delta);
  int col1=-1;
  if(strlen(label_snum)>0 && strlen(fits_alpha)>0)
    col1 = fbr.AddCol(label_snum,fits_alpha,hdu_alpha);

  fbr.Print(3);
  cout<<"NRows= "<<fbr.GetNbLine()<<endl;
  if(fbr.IsSNum()) fbr.SetNbLine(FitsBoloRead::ColSNum);
  cout<<"fbr.SetNbLine(ColSNum): NRows= "<<fbr.GetNbLine()<<endl;
  fbr.SetNbLine(-1);
  cout<<"fbr.SetNbLine(): NRows= "<<fbr.GetNbLine()<<endl;

#ifdef NO_VECTOR
  cout<<"Reading element by elements"<<endl;
  for(long i=0; i<fbr.GetNbLine(); i++) {
    double a=-1.,d=-1.,b=-1.,f=-1.,s=-1.,c1=-1.;
    if(fbr.IsAlpha())   a  = fbr.GetAlpha(i);
    if(fbr.IsDelta())   d  = fbr.GetDelta(i);
    if(fbr.IsBolo())    b  = fbr.GetBolo(i);
    if(fbr.IsSNum())    s  = fbr.GetSNum(i);
    if(fbr.IsFlag())    f  = fbr.GetFlag(i);
    if(col1>=0) if(fbr.IsCol(col1)) c1 = fbr.GetCol(col1,i);
    if(i%lpmod==0)
      cout<<i<<" s="<<(long long)s
          <<" b="<<b<<" f="<<f
          <<" a="<<a<<" d="<<d<<" c1="<<(long long)c1<<endl;
  }
#else
  cout<<"Reading with vectors"<<endl;
  long istep = lpmod;
  TVector<double> s,a,d,b,f,c1;
  TVector<int_4> si4,fi4;
  for(long i=0; i<fbr.GetNbLine(); i+=istep) {
    long i2=i+istep-1; if(i2>=fbr.GetNbLine()) i2=fbr.GetNbLine()-1;
    if(fbr.IsSNum())   {fbr.GetSNum(i,i2,s); fbr.GetSNum(i,i2,si4);}
    if(fbr.IsBolo())    fbr.GetBolo(i,i2,b);
    if(fbr.IsFlag())   {fbr.GetFlag(i,i2,f); fbr.GetFlag(i,i2,fi4);}
    if(fbr.IsAlpha())   fbr.GetAlpha(i,i2,a);
    if(fbr.IsDelta())   fbr.GetDelta(i,i2,d);
    if(col1>=0) if(fbr.IsCol(col1)) fbr.GetCol(col1,i,i2,c1);
    for(int j=0; j<2; j++) {
      int ii = 0; if(j==1) ii=i2-i;
      cout<<i<<"("<<ii<<") ";
      if(fbr.IsSNum())    cout<<" s=("<<s(ii)<<","<<si4(ii)<<")";
      if(fbr.IsBolo())    cout<<" b="<<b(ii);
      if(fbr.IsFlag())    cout<<" f=("<<f(ii)<<","<<fi4(ii)<<")";
      if(fbr.IsAlpha())   cout<<" a="<<a(ii);
      if(fbr.IsDelta())   cout<<" d="<<d(ii);
      if(col1>=0) if(fbr.IsCol(col1)) cout<<" c1="<<c1(ii);
      cout<<endl;
    }
  }
#endif

#ifdef USE_EXCEPT
} catch (PThrowable & exc) {
  cout<<"Exception : "<<(string)typeid(exc).name()
      <<" - Msg= "<<exc.Msg()<<endl;
  return -2;

} catch (...) {
  cout<<" some other exception was caught !"<<endl;
  return -2;
}
#endif

 return 0;
}
