#include "sopnamsp.h"
#include "machdefs.h"
#include <stdio.h>
#include <stdlib.h>
#include "math.h"
#include <iostream>
#include <string>
#include <vector>

#include <typeinfo>

#include "sophyainit.h"
#include "randr48.h"
#include "timing.h"
#include "ctimer.h"
#include "pqnumber.h"
#include "sunitpcst.h"

/*  Programme test des classes  PrimeNumbers, QNumber ...      */
/*  SOPHYA - R. Ansari (LAL)     -   Janvier 2012              */

int main(int narg, char* arg[])
{
  cout << " ---- Programme tpqunits.cc - Test classe PrimeNumbers, QNumber --- " << endl;
  int rc = 0;
  try {
    SophyaInit();
    /*
    PPRegister(ObjFileIO<Units>);
    DObjRegister(ObjFileIO<Units>, Units);
    PPRegister(ObjFileIO<PhysQty>);
    DObjRegister(ObjFileIO<PhysQty>, PhysQty);
    */    
    InitTim(); 
    cout << " Sizeof(PrimeNumbers=) " << sizeof(PrimeNumbers) << endl;
    cout << " Sizeof(QNumber=) " << sizeof(QNumber) << endl;
    
    cout << " ------------------------------------------------ " << endl;
    cout << " ------- Test de la classe PrimeNumbers -------- " << endl;
    // Create a PrimeNumbers object 
    PrimeNumbers primes;
    int NBPRTPRIMES=50;
    // Print the first NBPRTPRIMES primes ...
    cout << "Test_PrimeNumbers: First " << NBPRTPRIMES << " prime numbers : " << endl;
    for(size_t k=0; k<NBPRTPRIMES; k++) {
      cout << primes(k) << " , "; 
      if (k%10==0) cout << endl;
    }
    cout << endl;
    PrtTim("End first 50 primes");
    cout << " primes[1000000]=" << primes[1000000] << endl; 
    PrtTim("End primes[1000000]");
    cout << endl;
    // Print all prime numbers less than some max values
    uint_8 pmax = 1023;
    cout << "Test_PrimeNumbers: prime numbers less than " << pmax << endl;
    uint_8 p = primes.Next();
    int cnt=0;
    while (p<pmax) {
      cout << p << " , ";  cnt++;
      if (cnt%10==0)  cout << endl;
      p = primes.Next();
    }
    cout << endl;
    uint_8 nombre,nombres[6]={247890,1542297,8255846,2946868,1570889,22702166};
    const char* decomps[6]={"2 x 3 x 5 x 8263","3 x 41 x 12539","2 x 17 x 242819","2 x 2 x 736717","1570889","2 x 11351083"};
    for(int i=0; i<6; i++) {
      nombre=nombres[i];
      PrimeNumbers::PrimeFactors(nombre, true);
      cout << "    ...MathematicaCheck:  OK if == " << decomps[i]  << endl;
    }  
    cout << endl;
    DR48RandGen rnd;
    rnd.AutoInit();
    for(int i=0; i<5; i++) {
      nombre=rnd.Flat01()*30000000.;
      PrimeNumbers::PrimeFactors(nombre, true);
    }
    cout << endl;
    PrtTim("End PrimeFactors");
   
    cout << endl;
    cout << " ------------------------------------------------ " << endl;
    cout << " -------- Test de la classe QNumber -------- " << endl;
    // Create rational numbers from integers
    QNumber q1(3,4), q2(5,6), q3(6,8);
    // Operations and comparsion
    QNumber q4 = q1+q2; 
    cout << "Test_QNumber q4=q1+q2: " << q1 << " + " << q2 << " = " << q4 
	 << " q4.Simplify()=" << q4.Simplify() << endl;
    QNumber qa(q1), qb(q2);
    cout << "Test_QNumber if(qa==qb) : -> " << qa << " ?== " << qb;
    if (qa == qb)  cout << " -> true " << endl;
    else cout << " -> false " << endl;
    qb = q3;
    cout << "Test_QNumber if(qa==qb) : -> " << qa << " ?== " << qb;
    if (qa == qb)  cout << " -> true " << endl;
    else cout << " -> false " << endl;
    cout << "Test_QNumber.Simplify: [ 3*7*17*5,(-5)*7*11*2 ] : " << endl;
    QNumber qq(3*7*17*5,(-5)*7*11*2);
    cout << " qq= " << qq << "  qq.Simplify() = " << qq.Simplify() << endl;

    cout << endl;
    cout << " ------------------------------------------------ " << endl;
    cout << " ---- Test de la classe Units ---- " << endl;
    cout << " units::meter() : " << Units::meter() << " ( ";
    Units::meter().Print(cout,1) << " ) " << endl;
    Units::meter().Print() << endl;
    
    cout << " units::kilogram() : " << Units::kilogram() << endl; 
    cout << " units::second() : " << Units::second() << endl; 

    Units mos = Units::meter()/Units::second() ;
    cout << " units::m/s : " << mos << "  -> "; mos.Print() ;  

    cout << " units::watt() : " << Units::watt() << endl; 
    Units::watt().Print() << endl;

    cout << " units::watt().mega() : " << Units::watt().mega() << endl; 
    Units::watt().mega().Print() << endl;

    cout << endl;
    cout << " ------------------------------------------------ " << endl;
    cout << " ---- Test de la classe PhysQty ---- " << endl;
    cout <<  " c (speed of light): " << PhysQty::c() << endl;
    cout <<  " k_Boltzmann: " << PhysQty::k() << endl;
    cout <<  " G_Newton: " << PhysQty::G() << endl;
    cout <<  " h_Planck: " << PhysQty::h() << endl;
    cout <<  " R: " << PhysQty::R() << endl;
    cout <<  " N_A: " << PhysQty::N_A() << endl;
    cout <<  " m_e: " << PhysQty::electron_mass() << endl;
    cout <<  " m_p: " << PhysQty::proton_mass() << endl;

    {
      cout << " --->> Writing watt, c, k_Boltzmann, G_Newton to tpqunits.ppf ... " << endl;
      POutPersist po("tpqunits.ppf");
      Units uw = Units::watt();
      PhysQty c = PhysQty::c();
      PhysQty k = PhysQty::k();
      PhysQty G = PhysQty::G();
      po << uw << c << k << G;
    }
    {
      cout << " --->> Reading unit u1, physical quantities ( pq1 pq2 pq3  ) from tpqunits.ppf ... " << endl;
      PInPersist pi("tpqunits.ppf");
      Units u1;
      PhysQty pq1,pq2,pq3;
      pi >> u1 >> pq1 >> pq2 >> pq3;
      u1.Print(2);
      pq1.Print(1) << endl;
      pq2.Print(1) << endl; 
      pq3.Print(1) << endl;
    }

  }
  catch (PThrowable & exc) {
    cerr << " tpqunits.cc: Catched Exception (PThrowable)" << (string)typeid(exc).name() 
	 << " - Msg= " << exc.Msg() << endl;
    rc = 99;
  }
  catch (std::exception & e) {
    cerr << " tpqunits.cc: Catched std::xception "  
	 << " - what()= " << e.what() << endl;
    rc = 98;
  }
  catch (...) {
    cerr << " tpqunits.cc: some other exception (...) was caught ! " << endl;
    rc = 97;
  }
  PrtTim("End tpqunits " );
  cout << " ---- Programme tpqunits.cc-  FIN  (Rc=" << rc << ") --- " << endl;
  return rc;
}
