// Module PI : Peida Interactive   - ucckprot.h
// Protection transfo coordonnees UserCoord<>GraphicCoord 
//                    C. Magneville, R. Ansari  2002
// LAL (Orsay) / IN2P3-CNRS  DAPNIA/SPP (Saclay) / CEA

#ifndef UCCKPROT_H_SEEN
#define UCCKPROT_H_SEEN

#include <math.h>
//  Pour la declaration de finite() isnan() ...
#if defined(SunOS)
#include <ieeefp.h>
#endif

#define PETIT_DBLE 1.e-85
// qque probleme sur le trace - J'augmente les marges - Reza 14/5/2002 
// #define PREC_DBLE  1.e-16  
#define PREC_DBLE  1.e-14
#define MINRAP_DBLE  1.e-12
// Avril 2012 (cmv+reza) : on passe les limites de protection double de 1e+/-100 a 1e+/-250 
#define PROT_DBLE_MIN  1.e-250
#define PROT_DBLE_MAX  1.e+250

inline double UC_LimitProtectDouble(double x)
{ 
  if (x < 0.) {
    if (x < -PROT_DBLE_MAX) return (-PROT_DBLE_MAX);
    if (x > -PROT_DBLE_MIN) return (-PROT_DBLE_MIN);
    return(x);
  }
  else {
    if (x > PROT_DBLE_MAX) return (PROT_DBLE_MAX);
    if (x < PROT_DBLE_MIN) return (PROT_DBLE_MIN);
    return(x);
  }
}

inline bool UC_CheckMinMaxDiff(double& xmin, double& xmax) 
{
  bool rc = false;
  double xym,xym2;
  if (xmax<xmin) xmax=xmin;
  xym = fabs(xmax);
  xym2 = fabs(xmin);
  if (xym2 > xym) xym = xym2;
  if (xym < PETIT_DBLE) xym = PETIT_DBLE;
  if ((xmax-xmin) < MINRAP_DBLE*xym) {
    //    printf("UC_CheckMinMaxDiff_Debug: xmin=%.15e xmax=%.15e diff=%.15e \n",xmin,xmax,xmax-xmin); 
    xmin -= MINRAP_DBLE*xym*0.5;  xmax += MINRAP_DBLE*xym*0.5;; // xmax = xmin+MINRAP_DBLE*xym;
    //    printf(" ...Changed to --> xmin=%.15e xmax=%.15e diff=%.15e \n",xmin,xmax,xmax-xmin); 
    rc = true;
  }
  return(rc);
}

inline bool UC_CheckFinite(double xmin, double xmax)
{
#if defined(OSF1) || defined(SunOS) || defined(Darwin) || (defined(Linux) && !defined(__KCC__) )
  if (finite(xmin) && finite(xmax)) return(true);
  else return(false);
#else
  return(true);
#endif
}

#endif
