// gyrohandler.h
// Eric Aubourg         CEA/DAPNIA/SPP   septembre 1999

#ifndef GYROHANDLER_H
#define GYROHANDLER_H


#ifndef nb_max_bolo
#define _archeops		//  Acquisition Archeops (avec transputer) 
#define programme
extern "C" {
#include "archeops.h"
}
#endif

class GyroHandler {
public:
  GyroHandler();
  GyroHandler(GyroHandler const&);
  GyroHandler& operator = (GyroHandler const&);
  virtual ~GyroHandler();

  void ProcessBlock(block_type_gyro*);
  int4 getRawSignal(int imesure, int igyro); // for last block
  double getSignal(int imesure, int igyro);    // for last block, mV
  double getSpeed(int imesure, int igyro);    // for last block, deg/s

protected:
  int4  gyro[3][nb_per_block*2];
};


// To be done : handle calibration, through stellar sensor, temperature, etc.

#endif
