// archtoi.h
// Eric Aubourg         CEA/DAPNIA/SPP   juillet 1999

#ifndef ARCHTOI_H
#define ARCHTOI_H

#include <iostream.h>
#include <string>
#include <list>
#include <vector>
#include "toisvr.h"
#include "fitsio.h"

using namespace std; 

class ArchTOI : public RequestHandler {
public:
  ArchTOI(istream& str);
  ArchTOI(string const& filename);

  void run(string const& outfilename);
  
  enum fmt {ascii_fmt, fits_fmt};
  enum flg {hasflag = 1,
            useNA   = 2};
            
  virtual bool processTOIReq(string line, string toiname, TOIKind toi, int index, 
                             bool interp, bool repet, bool flag, bool notrig);
  virtual bool processOption(string keyw, string args);
  
protected:
  void init();
  TOISvr svr;
  list<string> headertoi;
  list<string> headeropt;
  list<string> toinames;
  vector<flg>  toiflags;
  fmt format;
  string undef;
  bool allBolos; // tous les bolos dans le header. Sinon seulement bolos transmis.
  
  void (ArchTOI::*openFile)(string const& filename);
  void (ArchTOI::*outHeader)(TOIIter& iter);
  void (ArchTOI::*outValue)(int icolumn, double value, bool notdef=false);
  void (ArchTOI::*endLine)();
  void (ArchTOI::*closeFile)();
  
  void openFile_A(string const& filename);
  void outHeader_A(TOIIter& iter);
  void outValue_A(int icolumn, double value, bool notdef=false);
  void endLine_A();
  void closeFile_A();

  void openFile_F(string const& filename);
  void outHeader_F(TOIIter& iter);
  void outValue_F(int icolumn, double value, bool notdef=false);
  void endLine_F();
  void closeFile_F();
  
  fitsfile* fptr;
  int fitsStatus;
  int fitsLine;
  ostream* ostr;
  
  string requestVersion;
  list<string> comments;
};

#define ARCHTOI_VERS "1.1"
#define ARCHTOI_TAG  "notag"

#endif
