// gyrohandler.cc
// Eric Aubourg         CEA/DAPNIA/SPP   septembre 1999

#include <string.h>
#include "gyrohandler.h"


GyroHandler::GyroHandler() {
 memset(gyro, 0, 3*nb_per_block*2*sizeof(int4));
}

  
GyroHandler::GyroHandler(GyroHandler const& x) {
  memcpy(gyro, x.gyro, 3*nb_per_block*2*sizeof(int4));
}

GyroHandler& GyroHandler::operator = (GyroHandler const& x) {
  memcpy(gyro, x.gyro, 3*nb_per_block*2*sizeof(int4));
  return *this;
}

GyroHandler::~GyroHandler() {

}

void GyroHandler::ProcessBlock(block_type_gyro* blk) {
  memcpy(gyro, blk->gyro, 3*nb_per_block*2*sizeof(int4));
}

int4  GyroHandler::getRawSignal(int imesure, int igyro) {
  if (igyro<0 || igyro>=3) return 0;
  if (imesure<0 || imesure>=nb_per_block*2) return 0;
  return gyro[igyro][imesure]-32768;
}

double GyroHandler::getSignal(int imesure, int igyro) {  // V
  return getRawSignal(imesure, igyro) * 2. / 32768.; // +- 2V dynamique sur 16 bits
}

double GyroHandler::getSpeed(int imesure, int igyro) {
  return getSignal(imesure, igyro) * 10;
}
