/*
 *  PIWindowQuartz.h
 *  PI
 *
 *  Created by Bruno MANSOUX on Tue Apr 13 2004.
 *  Copyright (c) 2004 __MyCompanyName__. All rights reserved.
 *
 */

#include <Carbon/Carbon.h>

#ifndef PIWINDOW_QUARTZ_SEEN
#define PIWINDOW_QUARTZ_SEEN

#include "piwindowgen.h"

/*
EventTypeSpec windowEvents[] = {{kEventClassWindow, kEventWindowUpdate}};
*/

class PIWindowQuartz : public PIWindowGen
{
public:
// Les methodes ...
    PIWindowQuartz(PIMsgHandler *par, const char *nom, PIWindowKind k=PIWK_normal, 
                int sx=10, int sy=10, int px=0, int py=0);

  virtual 	 ~PIWindowQuartz();

  virtual void   SetSize(int sx, int sy);
  virtual void   SetPos(int px, int py);

  virtual void   Manage();
  virtual void   UnManage();
  virtual bool   IfManaged();
  virtual bool   IsVisible();

//  Fonction qui doit etre appelee pour rafraichir la fenetre 
  virtual void   Refresh();
  virtual void   Show();

//  Pour rendre un composant graphique (PIWindowQuartz) sensible/insensible 
  virtual void           SetSensitive();
  virtual void           SetUnSensitive();
  virtual bool           IfSensitive();

//  Gestion des EventHandler
  virtual void		 AddEventHandler(PIEventHandler* evh, unsigned long evtmask, bool ad=false);
  virtual void		 RemoveEventHandler(PIEventHandler* evh);

// En public, pour permettre l'acces depuis call-back Xt
  virtual void		 CallDrawHandlers(int x0, int y0, int dx, int dy); 
  virtual void		 CallEventHandlers(unsigned long evt, int px, int py,
                                           int k, int km, unsigned long tm);
protected:
    WindowRef	wRef;
	WindowRef	wParent;
};


typedef PIWindowQuartz PIWindow;

#endif
