#ifndef PICMAPQUARTZ_H_SEEN
#define PICMAPQUARTZ_H_SEEN

#include "picmapgen.h"

typedef unsigned long PIQuartzColor ;


class PIColorMapQuartz : public PIColorMapGen {
public:
  PIColorMapQuartz();  
  PIColorMapQuartz(int id, int nc, string const& nom);  
  virtual ~PIColorMapQuartz();

  // Fonction Color() est definie afin de permettre l'optimisation - affichage d'image, etc...
  inline PIQuartzColor  Color(int index) 
    { return (((index < mNCol)&&(index>=0)) ? 
	      mColors[(mFlagReversedIndex)?mNCol-index-1:index] : 0); } ;

  virtual PIColor GetColor(int n);
  virtual bool AllocColor(PIColor const& col, int index);
  virtual void FreeColors();

  virtual long TotNbColors();
  virtual int  NbAllocColors();

protected:
  virtual void CopyFrom(PIColorMapGen*);
  
  PIQuartzColor  * mColors;     // La table des couleurs ...
  PIColor   * mColRGB;     // Composantes RGB  
  bool * mNewCol;          // Nouvelle couleur dans table ou pas
};

typedef PIColorMapQuartz PIColorMapNative;

#endif
