// Module PI : Peida Interactive     PIFontQuartz
// Gestion de fontes - Implementation MACOSX    
// LAL (Orsay) / IN2P3-CNRS          Reza+Bruno 2008

#include <stdio.h>

#include "sopnamsp.h"
#include "pisysdep.h"
#include "pifontquartz.h"
#include PIWDG_H

/* --Methode-- */
PIFontQuartz::PIFontQuartz(PIFontName fn)
  : PIFontGen(fn) , mFSize(-1) 
{
//GlInit();
SelectFont(fn, PI_RomanFont, PI_NormalSizeFont);
}

/* --Methode-- */
PIFontQuartz::PIFontQuartz(int npt, PIFontName fn, PIFontAtt fa)
  : PIFontGen(npt, fn, fa), mFSize(-1) 
{
//GlInit();
SelectFontPt(fn, fa, npt);
}

/* --Methode-- */
PIFontQuartz::PIFontQuartz(PIFontQuartz const & fnt)
  : PIFontGen(fnt.mFName), mFSize(-1) 
{
// GlInit();
SelectFontPt(fnt.mFName, fnt.mFAtt, fnt.mFSize);
}

/* --Methode-- */
PIFontQuartz::~PIFontQuartz()
{
}

/* --Methode-- */
PIFontQuartz & PIFontQuartz::operator = (PIFontQuartz const & fnt)
{
SelectFontPt(fnt.mFName, fnt.mFAtt, fnt.mFSize);
return(*this);
}

/* --Methode-- */
bool PIFontQuartz::operator == (PIFontQuartz const & fnt)
{
if ((fnt.mFName == mFName) && (fnt.mFAtt == mFAtt) && (fnt.mFSize == mFSize)) 
  return(true);
else return(false);
}

/* --Methode-- */
void PIFontQuartz::SetFont(PIFontName fn)
{
SelectFontPt(fn, mFAtt, mFSize);
}

/* --Methode-- */
void PIFontQuartz::SetFontAtt(PIFontAtt fa)
{
SelectFontPt(mFName, fa, mFSize);
}

/* --Methode-- */
void PIFontQuartz::SetFontSz(PIFontSize fs)
{
SelectFont(mFName, mFAtt, fs);
}

/* --Methode-- */
void PIFontQuartz::SetFontSzPt(int npt)
{
SelectFontPt(mFName, mFAtt, npt);
}

/* --Methode-- */
PIFontName PIFontQuartz::GetFontName() const
{
return(mFName);
}

/* --Methode-- */
PIFontAtt PIFontQuartz::GetFontAtt() const
{
return(mFAtt);
}

/* --Methode-- */
int PIFontQuartz::GetFontSzPt() const
{
return(mFSize);
}


/* --Methode-- */
int PIFontQuartz::GetFontHeight(int& asc, int& desc) const
{
return 10;
/*
char a[2];
XCharStruct  ovr;
int hd, fa, fd;
XTextExtents(mFSt, a, 0, &hd, &fa, &fd, &ovr);
asc = fa; desc = fd; 
return(fa+fd);
*/
}

/* --Methode-- */
int PIFontQuartz::GetStringWidth(char const* s) const
{
return (10*strlen(s));
//return(XTextWidth(mFSt, s, strlen(s)));
}

/* --Methode-- */
PIFontSize PIFontQuartz::GetFontSz() const
{
  PIFontSize rs = PI_NormalSizeFont;
return(rs);
}

/* --Methode-- */
void PIFontQuartz::SelectFont(PIFontName fn, PIFontAtt fa, PIFontSize fs)
{
/*
int isz;
switch (fs) {
  case PI_TinySizeFont:
    isz = fntsz[TinyFontIndex];
    break;
  case PI_SmallSizeFont:
    isz = fntsz[SmallFontIndex];
    break;
  case PI_NormalSizeFont:
    isz = fntsz[NormalFontIndex];
    break;
  case PI_LargeSizeFont:
    isz = fntsz[LargeFontIndex];
    break;
  case PI_VeryLargeSizeFont:
    isz = fntsz[VeryLargeFontIndex];
    break;
  case PI_HugeSizeFont:
    isz = fntsz[HugeFontIndex];
    break;
  default:
    isz = fntsz[NormalFontIndex];
    break;
  }

SelectFontPt(fn, fa, isz);
*/
return;
}

/* --Methode-- */
void PIFontQuartz::SelectFontPt(PIFontName fn, PIFontAtt fa, int npt)
{
/*
if ( (mFSize > 0) && (fn == mFName) && (fa == mFAtt) && (npt == mFSize) )   return;
int dsz,i,isel, j, k;
isel = 0;
dsz = 9999;
for(i=0; i<NMAXFONTSZ; i++)
  {
  j = npt - fntsz[i];   if (j < 0)  j = -j;
  if (j < dsz)  {  isel = i; dsz = j; }
  }
i = isel;
j = 0;
switch (fa) {
  case PI_RomanFont :
    j = 0;
    break;
  case PI_BoldFont :
    j = 1;
    break;
  case PI_ItalicFont :
    j = 2;
    break;
  case PI_BoldItalicFont :
    j = 3;
    break;   
  default :
    j = 0;
    break;
  }

k = 0;
switch (fn)
 {
  case PI_DefaultFont :
    k = 0;
    break;
  case PI_CourierFont :
    k = 1;
    break;
  case PI_HelveticaFont :
    k = 2;
    break;
  case PI_TimesFont :
    k = 3;
    break;
  case PI_SymbolFont :
    k = 4;
    break;
  default :
    k = 0;
    break;
  }
LoadFontSt(i, j, k);
*/
return;
}
