// This may look like C code, but it is really -*- C++ -*-
// Module PI : Peida Interactive     PIFontQuartz
// LAL (Orsay) / IN2P3-CNRS          Reza+Bruno 2008


#ifndef PIFONTQUARTZ_H_SEEN
#define PIFONTQUARTZ_H_SEEN

#include "pisysdep.h"
#include "pifontgen.h"


class PIFontQuartz : public PIFontGen 
{
public :
		PIFontQuartz(PIFontName fn = PI_DefaultFont) ;
		PIFontQuartz(int npt, PIFontName fn = PI_DefaultFont, 
                        PIFontAtt fa = PI_RomanFont);
		PIFontQuartz(PIFontQuartz const & fnt);
  virtual	~PIFontQuartz();

  virtual PIFontQuartz & operator = (PIFontQuartz const & fnt);
  virtual bool operator == (PIFontQuartz const & fnt);

  virtual void		SetFont(PIFontName fn);
  virtual void		SetFontAtt(PIFontAtt fa);
  virtual void		SetFontSz(PIFontSize fs);
  virtual void		SetFontSzPt(int npt);

  virtual PIFontName    GetFontName() const ;
  virtual PIFontAtt     GetFontAtt() const ;
  virtual PIFontSize    GetFontSz() const;
  virtual int		GetFontSzPt() const ;

  virtual int		GetFontHeight(int& asc, int& desc) const ;
  virtual int		GetStringWidth(char const* s) const ;

protected:
  void           SelectFont(PIFontName fn, PIFontAtt fa, PIFontSize fs);
  void           SelectFontPt(PIFontName fn, PIFontAtt fa, int npt);

  PIFontName mFName;
  PIFontAtt mFAtt;
  int mFSize;
};

typedef PIFontQuartz PIFont;

#endif      // PIFONTQUARTZ_H_SEEN
