// This may look like C code, but it is really -*- C++ -*-
// Module PI : Peida Interactive     PILineAtt 
// Gestionnaire d'attributs de ligne   R. Ansari  2002
// LAL (Orsay) / IN2P3-CNRS  DAPNIA/SPP (Saclay) / CEA

#include "sopnamsp.h"
#include "pilineatt.h"
#include <math.h>

//++
// Class	PILineAtt
// Lib		PI
// include	pilineatt.h
//--
//++
// Links	Voir aussi
// PIGraphic
// PIGraphicAtt
//--
//++
// Titre	Constructeurs
//--
//++
// explicit PILineAtt(int width=1, PILineDash dash=PI_LineSolid, \
//          PILineJoin join=PI_JoinMiter, PILineCap cap=PI_CapButt)
//	Constructeur avec possibilit de spcification de tous les 
//	attributs de ligne.
//
//	enum PILineDash :
//|	PI_LineSolid, PI_LineDashed
//|	PI_LineDotted, PI_LineDashDotted
//
//	enum  PILineJoin :
//|	PI_JoinMiter, PI_JoinRound, PI_JoinBevel
//	enum  PILineCap :
//|	PI_CapButt, PI_CapRound, PI_CapProjecting
//
// explicit PILineAtt(double width, PILineDash dash=PI_LineSolid, \
//          PILineJoin join=PI_JoinMiter, PILineCap cap=PI_CapButt)
//	Constructeur. 
//
// PILineAtt(PILineAtt const& b)
//	Constructeur de copie.
//
// PILineAtt(PILineTypes ltyp)
//	Constructeur  partir de l'enum *PILineTypes*
//|	PI_NotDefLineAtt
//|	PI_NormalLine, PI_ThinLine, PI_ThickLine
//|	PI_DashedLine, PI_ThinDashedLine, PI_ThickDashedLine
//|	PI_DottedLine, PI_ThinDottedLine, PI_ThickDottedLine
//|	PI_DashDottedLine, PI_ThinDashDottedLine, PI_ThickDashDottedLine
//--

/* --Methode-- */
PILineAtt::PILineAtt(PILineTypes ltyp)
{
  _lwidth = 2*8;
  _ldash=PI_LineSolid; 
  _ljoincap = PI_JoinMiter*PI_CapButt*256;
  switch (ltyp) {
    case PI_NotDefLineAtt :
      _lwidth = 0; _ldash=PI_LineSolid; 
      break;
    case PI_NormalLine : 
      _lwidth = 2*8; _ldash=PI_LineSolid; 
      break;
    case PI_ThinLine : 
      _lwidth = 8; _ldash=PI_LineSolid; 
      break;
    case PI_ThickLine : 
      _lwidth = 8*4; _ldash=PI_LineSolid; 
      break;
    case PI_DashedLine : 
      _lwidth = 2*8; _ldash=PI_LineDashed; 
      break;
    case PI_ThinDashedLine : 
      _lwidth = 8; _ldash=PI_LineDashed; 
      break;
    case PI_ThickDashedLine : 
      _lwidth = 8*4; _ldash=PI_LineDashed; 
      break;
    case PI_DottedLine : 
      _lwidth = 2*8; _ldash=PI_LineDotted; 
      break;
    case PI_ThinDottedLine : 
      _lwidth = 8; _ldash=PI_LineDotted; 
      break;
    case PI_ThickDottedLine : 
      _lwidth = 8*4; _ldash=PI_LineDotted; 
      break;
    case PI_DashDottedLine : 
      _lwidth = 2*8; _ldash=PI_LineDashDotted; 
      break;
    case PI_ThinDashDottedLine : 
      _lwidth = 8; _ldash=PI_LineDashDotted; 
      break;
    case PI_ThickDashDottedLine : 
      _lwidth = 8*4; _ldash=PI_LineDashDotted; 
      break;
    default :
      _lwidth = 0; _ldash=PI_LineSolid; 
      break;
    
  }
}

//++
// Titre	Oprateurs 
//--

//++
// PILineAtt& operator = (PILineAtt const& b)
//	Oprateur d'affectation  partir d'un PILineAtt.
// PILineAtt& operator = (PILineTypes ltyp)
//	Oprateur d'affectation  partir d'un PILineTypes.
// bool operator == (PILineAtt const& b) const
//	Oprateur test d'galit avec un PILineAtt
// bool operator == (PILineTypes ltyp)
//	Oprateur test d'galit avec un PILineTypes
// bool operator != (PILineAtt const& b) const
//	Oprateur test d'ingalit avec un PILineAtt
// bool operator != (PILineTypes ltyp)
//	Oprateur test d'ingalit avec un PILineTypes
//--

//++
// Titre	Mthodes
//--

//++
// int GetLineWidth() const
//	Retourne l'paisseur de ligne (en pixels).
// int GetLineWidthx8() const
//	Retourne l'paisseur de ligne (en 1/8 pixels ou points).
// double GetLineWidthD() const
//	Retourne l'paisseur de ligne (valeur flottante en pixels/points).
// PILineDash GetLineDash()
//	Retourne le type de ligne pointill
// PILineJoin GetLineJoin()
//	Retourne le type de jointure de lignes
// PILineCap  GetLineCap()
//	Retourne le type de terminaison de lignes
// void SetLineWidth(int lw)
//	Dfinit l'paisseur de ligne (en pixels/points).
// void SetLineWidth(double lw)
//	Dfinit l'paisseur de ligne (valeur flottante en pixels/points).
// void SetLineDash(PILineDash ld)
//	Dfinit le type de ligne pointill - enum PILineDash :
//|	PI_LineSolid, PI_LineDashed
//|	PI_LineDotted, PI_LineDashDotted
//
// void SetLineJoin(PILineJoin lj)
//	Dfinit le type jointure de lignes - enum  PILineJoin :
//|	PI_JoinMiter, PI_JoinRound, PI_JoinBevel
// void SetLineCap(PILineCap lc) 
//	Dfinit le type terminaison de lignes - enum  PILineCap :
//|	PI_CapButt, PI_CapRound, PI_CapProjecting
//--
