/*
 *  PIMenuQuartz.cpp
 *  PI
 *
 *  Created by Bruno MANSOUX on Fri May 28 2004.
 *  Copyright (c) 2004 __MyCompanyName__. All rights reserved.
 *
 */

#include "PIMenuQuartz.h"

/* ----------------------------- Methode ------------------------------- */
PIMenuQuartz::PIMenuQuartz(PIWdg* par, const char* nom, PIMenuType pdpu)
:PIMenuGen(par, nom, pdpu)
{
    static int mMenuIdentificateur = 130;
    Str255 menuTitle;

    mNItem = 0;  mNItemMax = 0;     
    mMenuID = mMenuIdentificateur++;

//    Beware with using this attribute, no place for check mark!
//    CreateNewMenu (mMenuID, kMenuAttrExcludesMarkColumn, &mMenu);

//  Popupmenu are associated with ButtonControl
    if (pdpu == k_PopupMenu)
	{
		CreateNewMenu (mMenuID, kMenuAttrHidden, &mMenu);
	}
    else
	{
		CreateNewMenu (mMenuID, kMenuAttrAutoDisable, &mMenu);
    }
	
	parent = par;
    CopyCStringToPascal (nom, menuTitle);
    SetMenuTitle (mMenu, menuTitle);
    mItems = NULL;
}

/* ----------------------------- Methode ------------------------------- */
PIMenuQuartz::~PIMenuQuartz()
{
    delete[] mItems;
}
				   
/* ----------------------------- Methode ------------------------------- */
void PIMenuQuartz::AppendItem(const char* nom, PIMessage msg, char* sc)
{
	static int mMenuItemIdentificateur = 300;
	static int mNumberOfItemMax = 0;
    pistring itemTitle;
    _pimqit_ *mItemsLoc;
    int mNItemsPrev;

    /* Mise a jour de la liste des items */
    mItemsLoc = mItems;
    mNItemsPrev = mNItemMax;
    mNItemMax++;
    mItems = new _pimqit_[mNItemMax];
    for (int i = 0; i < mNItemsPrev; i++)
    {	
        mItems[i] = mItemsLoc[i];
    }
    /* Ajout du nouvel Item */
    CopyCStringToPascal (nom, itemTitle);
    InsertMenuItem(mMenu, itemTitle, mNItemMax);
    SetMenuItemCommandID (mMenu, mNItemMax, mMenuItemIdentificateur);

    mItems[mNItemsPrev].itemId = mMenuItemIdentificateur;
    mItems[mNItemsPrev].pim = this;
    mItems[mNItemsPrev].msg = msg ;
    mItems[mNItemsPrev].itemString = CFStringCreateWithPascalString (NULL, itemTitle, kCFStringEncodingMacRoman);
    mItems[mNItemsPrev].itemIndex = mNItemMax; /* Attention, les items pour un Menu commencent a 1 et pas a 0 */
    
    if (mItemsLoc)
        delete[] mItemsLoc;

    mMenuItemIdentificateur++;

    return;
}
				   
/* ----------------------------- Methode ------------------------------- */
void PIMenuQuartz::AppendCheckItem(const char* nom, PIMessage msg, char* sc)
{
    int item;
    AppendItem(nom,msg,sc);
    item = GetNumItem(nom);
    CheckMenuItem (this->GetMenuRef(),mItems[item].itemIndex,true);
    return;	
}

/* ----------------------------- Methode ------------------------------- */
void PIMenuQuartz::AppendPDMenu(PIMenuGen *pdm, char* sc)
{
//    CreatePopupButtonControl();
    return;	
}

/* ----------------------------- Methode ------------------------------- */
void PIMenuQuartz::AppendCascadeMenu(PIMenuQuartz* cascadeMenu, PIMessage msg)
{
    int item;
    item = GetNumItemMsg(msg);
    
	SetMenuItemHierarchicalMenu (GetMenuRef(), 
								mItems[item].itemIndex, cascadeMenu->GetMenuRef());
								
    return;
}

/* ----------------------------- Methode ------------------------------- */
void PIMenuQuartz::AppendSeparator()
{
    static int mMenuItemSeparator = 100000;
    AppendItem(" ",mMenuItemSeparator++);
    ChangeMenuItemAttributes(mMenu,mNItemMax,kMenuItemAttrSeparator,kMenuItemAttrCustomDraw);
    return;	
}


/* ----------------------------- Methode ------------------------------- */
void PIMenuQuartz::DeleteItem(const char *nom)
{
    int itemNum;
    itemNum = GetNumItem(nom);
    
    if (itemNum > 0)
        DeleteItemNum(itemNum);

    return;
}

/* ----------------------------- Methode ------------------------------- */
void PIMenuQuartz::DeleteItemMsg(PIMessage msg)
{
    return;	
}

/* ----------------------------- Methode ------------------------------- */
void PIMenuQuartz::DeleteItemNum(int n)
{
    DeleteMenuItem (mMenu, mItems[n].itemIndex);
    return;	
}


/* ----------------------------- Methode ------------------------------- */
void PIMenuQuartz::SetSensitivity(const char *nom, bool sens)
{
    int itemNumber;
    itemNumber = GetNumItem (nom);
    SetSensitivityNum (itemNumber, sens);
    return;	
}

/* ----------------------------- Methode ------------------------------- */
void PIMenuQuartz::SetSensitivityMsg(PIMessage msg, bool sens) 
{
    int itemNumber;
    itemNumber = GetNumItemMsg (msg);
    SetSensitivityNum (itemNumber, sens);    
    return;	
}

/* ----------------------------- Methode ------------------------------- */
void PIMenuQuartz::SetSensitivityNum(int n, bool sens)
{
    if (sens)
        EnableMenuItem(mMenu,mItems[n].itemIndex);
    else
        DisableMenuItem(mMenu,mItems[n].itemIndex);
    return;	
}

/* ----------------------------- Methode ------------------------------- */
bool PIMenuQuartz::IsSensitive(const char *nom)
{
    int itemNumber;
    itemNumber = GetNumItem (nom);
    return (IsSensitiveNum(itemNumber));	
}

/* ----------------------------- Methode ------------------------------- */
bool PIMenuQuartz::IsSensitiveMsg(PIMessage msg)
{
    int itemNumber;
    itemNumber = GetNumItemMsg (msg);
    return (IsSensitiveNum(itemNumber));	
}

/* ----------------------------- Methode ------------------------------- */
bool PIMenuQuartz::IsSensitiveNum(int n)
{
    return(IsMenuItemEnabled(mMenu,mItems[n].itemIndex));	
}

/* ----------------------------- Methode ------------------------------- */
void PIMenuQuartz::SetState(const char *nom, bool st)
{
    int itemNumber;
    itemNumber = GetNumItem (nom);
    SetStateNum(itemNumber,st);
    return;	
}

/* ----------------------------- Methode ------------------------------- */
void PIMenuQuartz::SetStateMsg(PIMessage msg, bool st)
{
    int itemNumber;
    itemNumber = GetNumItemMsg (msg);
    SetStateNum(itemNumber,st);
    return;	
}

/* ----------------------------- Methode ------------------------------- */
void PIMenuQuartz::SetStateNum(int n, bool st)
{
    return;	
}
 
/* ----------------------------- Methode ------------------------------- */
bool PIMenuQuartz::GetState(const char *nom)
{
    int itemNumber;
    itemNumber = GetNumItem (nom);
    
    return (GetStateNum(itemNumber));	
}

/* ----------------------------- Methode ------------------------------- */
bool PIMenuQuartz::GetStateMsg(PIMessage msg)
{
    int itemNumber;
    itemNumber = GetNumItemMsg (msg);

    return (GetStateNum(itemNumber));	
}

/* ----------------------------- Methode ------------------------------- */
bool PIMenuQuartz::GetStateNum(int n)
{
    return (true);	
}

/* ----------------------------- Methode ------------------------------- */
void PIMenuQuartz::Show()
{
    /* Useful for PopupMenu */
    return;
}

/* ----------------------------- Methode ------------------------------- */
void PIMenuQuartz::Show(PIWdg *w, int px, int py)
{
    /* Useful for PopupMenu */
    return;	
}

/* ----------------------------- Methode ------------------------------- */
PIMessage PIMenuQuartz::GetMsgItem(int itemID)
{
    int itemNumber;
	
    for (itemNumber = 0 ; itemNumber < mNItemMax; itemNumber++)
	{
		if(mItems[itemNumber].itemId == (MenuCommand)itemID)
			return (mItems[itemNumber].msg);
	}
	
	return 0;
}

/* ----------------------------- Methode ------------------------------- */
int PIMenuQuartz::GetNumItem(const char* nom)
{
    int itemNumber;
    CFStringRef cfNom;
    CFComparisonResult result;
    bool find = FALSE;
    
    cfNom = CFStringCreateWithCString (NULL, nom,  kCFStringEncodingMacRoman);
    for (itemNumber = 0 ; itemNumber < mNItemMax; itemNumber++)
    {
        result = CFStringCompare (cfNom, mItems[itemNumber].itemString, 0);
        if (result == kCFCompareEqualTo)
        {
            find = TRUE;
            break;
        }
    }
    if (find)
        return (itemNumber);
    else
        return (-1);
}

/* ----------------------------- Methode ------------------------------- */
int PIMenuQuartz::GetNumItemMsg(PIMessage msg)
{
    int itemNumber;
    
    for (itemNumber = 0 ; itemNumber < mNItemMax; itemNumber++)
    {
        if (mItems[itemNumber].msg == msg) return itemNumber;
    }
    return (-1);
}

/* ----------------------------- Methode ------------------------------- */
char*  PIMenuQuartz::ItemName(int n)
{
    char* name;
    name = (char *)CFStringGetCStringPtr(mItems[n].itemString,kCFStringEncodingMacRoman);
    return (name);
}

/* ----------------------------- Methode ------------------------------- */
MenuRef PIMenuQuartz::GetMenuRef()
{
    return (mMenu);
}

/* ----------------------------- Methode ------------------------------- */
MenuID PIMenuQuartz::GetMenuID()
{
    return (mMenuID);
}

/* ----------------------------- Methode ------------------------------- */
PIWdg* PIMenuQuartz::GetParent()
{
    return (parent);
}


