// This may look like C code, but it is really -*- C++ -*-
// Module PI : Peida Interactive     PICMapView
// Visualisation de table de couleur     R. Ansari  07/98
// LAL (Orsay) / IN2P3-CNRS  DAPNIA/SPP (Saclay) / CEA

#ifndef PICMAPVIEW_H_SEEN
#define PICMAPVIEW_H_SEEN

#include "pisysdep.h"

#include PIBWDG_H
#include PICMAP_H

#include "pidrawer.h"
#include "lut.h"
#include <vector>


class PICMapView : public PIBaseWdg
{
public:
  enum {ClassId = 5210};

                  PICMapView(PIContainerGen *par, const char *nom,
                             int sx=256, int sy=10, int px=0, int py=0);
  virtual         ~PICMapView();

  virtual long	  kind() {return ClassId; }

  void            SetColMap(PIColorMap* cmp=NULL, double min=1., double max=-1., bool refr=true);
  void            SetColMapId(CMapId cmapid, bool revidx, double min, double max, bool refr);
  inline void     SetColMapId(CMapId cmapid, double min=1., double max=-1., bool refr=true)
                  { SetColMapId(cmapid, false, min, max, refr); }

// Traitement des evenements   

  virtual void   Draw(PIGraphic* g, int x0, int y0, int dx, int dy);


protected:
  PIColorMap* cmap;
  double vmin, vmax;
};

class PICMapDrawer : public PIDrawer
{
public:
                     PICMapDrawer(bool fgvert=false);
                     ~PICMapDrawer();

  virtual void       Draw(PIGraphicUC* g, double xmin, double ymin, double xmax, double ymax);
  inline void        SetHorizontal()  { fgvert_=false; }
  inline void        SetVertical()  { fgvert_=true; }

  inline void        SetColMapId(CMapId cmapid, bool revcidx=false) 
                     { cmapid_=cmapid;  revcidx_=revcidx;  cmapp=NULL;  return; }

  inline void        SetColMap(PIColorMap* cmp) 
                     { cmapp=cmp;  return; }

  void               SetBornes(LUT& lut);
  void               SetBornes(double min, double max);

protected:

  bool fgvert_;  // true -> vertical 
  bool fgtext_;  // true -> ecriture des valeurs des bornes
  PIColorMap* cmapp;  
  CMapId cmapid_;
  bool revcidx_;  // true -> reverse color map index 
  vector<double> bornes_;  
};


#endif 
