// This may look like C code, but it is really -*- C++ -*-
// Module PI : Peida Interactive      PIEventHandler
// Classe Gestionnaire d'evenements (Ecran/Clavier/Souris) 
//                                    R.Ansari  12/98 
// LAL (Orsay) / IN2P3-CNRS  DAPNIA/SPP (Saclay) / CEA

#ifndef PIEVTHANDLER_H_SEEN
#define PIEVTHANDLER_H_SEEN

#include "pisysdep.h"
#include "pimsghandler.h"
#include PIWDG_H
#include PIGRAPHIC_H


// ....  KeyModifier (<Shift>, <Control> , <Alt>) and special key values ....
enum PIKeyModifier { PIKM_Blank = 0, PIKM_Shift = 1, PIKM_Alt = 2, PIKM_Cntl = 4 } ; 

enum PIKeyValues { PIK_Return = 0xFF0D, PIK_Enter = 0xFF8D , 
                   PIK_BackSpace = 0xFF08, PIK_Delete = 0xFFFF,
                   PIK_Tab = 0xFF09, PIK_Escape = 0xFF1B, 
                   PIK_Up = 0xFF52, PIK_Down = 0xFF54, 
                   PIK_Right = 0xFF53, PIK_Left = 0xFF51,
                   PIK_Previous = 0xFF55, PIK_Next = 0xFF56  } ; 

// .......... Event Mask values ..........
enum PIEventMask {
     PIEvent_None	  =  0,                  //
     PIEvent_Draw         =  1 << 0,             // ReDraw window
     PIEvent_Resize       =  1 << 1,             // window resized
     PIEvent_Enter        =  1 << 2,             // Pointer entered window
     PIEvent_Leave        =  1 << 3,             // Pointer leaved window
     PIEvent_But1Press    =  1 << 4,             // Button-1 Press
     PIEvent_But1Release  =  1 << 5,             // Button-1 Release
     PIEvent_But2Press    =  1 << 6,             // Button-2 Press
     PIEvent_But2Release  =  1 << 7,             // Button-2 Release
     PIEvent_But3Press    =  1 << 8,             // Button-3 Press
     PIEvent_But3Release  =  1 << 9,             // Button-3 Release
     PIEvent_PtrMove      =  1 << 14,            // Pointer moved
     PIEvent_Ptr1Move     =  1 << 15,            // Pointer moved with button-1
     PIEvent_Ptr2Move     =  1 << 16,            // Pointer moved with button-2
     PIEvent_Ptr3Move     =  1 << 17,            // Pointer moved with button-3
     PIEvent_Keyboard     =  1 << 20             // key-pressed Keyboard
} ;


// -----------------  Class PIEventHandler  -----------------------
class PIEventHandler : public PIMsgHandler
{
public:
			PIEventHandler(PIMsgHandler* par=NULL, PIMessage msg = 0);
			~PIEventHandler();

  inline  void		SetMsg(PIMessage msg = 0) { myMsg=msg; }
  inline  PIMessage	Msg() { return (myMsg); }

  virtual void		Draw(PIGraphic* g, int x0, int y0, int dx, int dy);
  virtual void		ProcessEvent();

  virtual  void		SetCurrentWdg(PIWdg* wdg);
  inline  PIWdg*	CurrentWdg() { return(curwdg); }

  virtual void		SetEventInfo(PIEventMask evt, int px, int py, 
                                     int k, PIKeyModifier km, unsigned long tm);
  inline  PIEventMask	EventType() { return(event); }
  inline  int		GetPosX() { return(posx); }  
  inline  int		GetPosY() { return(posy); }  
  inline  int		GetKey() { return(key); }
  inline  PIKeyModifier GetKeyMod() { return(keymod); }
  inline  unsigned long GetEventTime() { return(evttime); }

protected:
  PIMessage	myMsg;	       // associated user message

  PIWdg*	curwdg;        // Current PIWdg, where event originated
  PIEventMask	event;	       // event type
  int		posx, posy;    // Pointer Position  
  int		key;	       // Pressed key-code 
  PIKeyModifier keymod;	       // Pressed key-modifier (shift, Cntl, ...)
  unsigned long evttime;       // Event-time in ms  
};



#endif  
