// Module PI : Peida Interactive     PIPixmap
// Classe de base pour affichage de pixmap  Reza 96
// LAL (Orsay) / IN2P3-CNRS  DAPNIA/SPP (Saclay) / CEA

#include <stdlib.h>
#include <stdio.h>

#include "sopnamsp.h"
#include "pipixmapgen.h"


// --------- Methodes de la classe PIPixMap  ----------
//++
// Class	PIPixmap
// Lib		PI
// include	pipixmapgen.h
//
//   	Classe pour la gestion optimise des pixmap.
//	Un pixmap est un tableau d'index dans une table de couleurs.
//	Cette classe gre actuellement des pixmaps avec des index
//	cods sur 8 bits (256 couleurs).
//	Pour des raisons d'optimisation, cette classe a une 
//	implmentation spcifique pour chaque plateforme.
//	La classe "PIPixmapGen" dfinit l'interface, et ne doit pas 
//	tre instancie directement.  Les objets instancis sont de la 
//	classes "PIPixmap" et le fichier entte correspondant est "PIPIXMAP_H"
//	dfini dans "pisysdep.h".
//--
//++
// Links	Parents
// PIBaseWdg
//--
//++
// Links	Voir aussi
// PIColorMap
//--

//++
// Titre	Constructeur, Pixmap
//--
//++
// PIPixmapGen(PIContainerGen *par, const char *nom, int sx=10, int sy=10, int px=0, int py=0)
//	Constructeur - Cration d'un "PIPIxmap".
// long  kind() 
//	Retourne le type ("=PIPixmap::ClassId")
// void  SetPixmap(PIPixColIdx *pixidx, int sx, int sy, bool refr=true, int ox=0, int oy=0)
//	Associe un tableau d'index de couleur "pixidx". (ox,oy)" dfinissent  l'offset d'affichage.
//	Si "refr=true", la mthode "Refresh()" est appele.
//--
//++
// Titre	Gestion de la table de couleur
//--
//++
// void  SetColMap(PIColorMap* cmp, bool refr=true)
//	Change la table de couleur associe.
//	Si "refr=true", la mthode "Refresh()" est appele.
// void  SetColMapId(CMapId cmapid, bool refr=true)
//	Change la table de couleur associe,  l'aide d'un identificateur
//	de table de couleur standard. ("CMapId cmapid").
//	Si "refr=true", la mthode "Refresh()" est appele.
// PIColorMap* GetColMap()
//	Retourne la table de couleur associe.
// CMapId GetColMapId() 
//	Retourne l'identificateur de la table de couleur associe.
// int NbCol()
//	Retourne le nombre de couleurs de la table de couleur associe.
//--

//++
// Titre	Actions
//--
//++
// void  But1Press(int x, int y)
//	L'action sur le bouton 1 dclenche l'envoi d'un message
//	avec le modifier PIMsg_Click. La position du bouton-press
//	est stock. (- Offset affichage)
// int  XPPos() 
//	Position X du click - Offset Affichage pixmap
// int  YPPos() 
//	Position Y du click - Offset Affichage pixmap
//--

/* --Methode-- */
PIPixmapGen::PIPixmapGen(PIContainerGen  *par, const char *nom,
                     int sx, int sy, int px, int py) :
PIBaseWdg(par, nom, sx, sy, px, py)
{
pixmap = NULL;
fgownpmap = false;
ofx = ofy = 0;
mPpos[0] = mPpos[0] = 0;
cmap = new PIColorMap(CMAP_GREY32);
ActivateButton(1);
}


/* --Methode-- */
PIPixmapGen::~PIPixmapGen()
{
delete cmap;
if (fgownpmap && pixmap) delete pixmap;
}

/* --Methode-- */
void PIPixmapGen::SetPixmap(PIPixColIdx *pixidx, bool refr, int ox, int oy)
{
if (fgownpmap && pixmap) delete pixmap;
fgownpmap = false;
pixmap = pixidx; 
if (ox < 0)  ox = 0;
if (oy < 0)  oy = 0;
ofx = ox;  ofy = oy;
if (refr) Refresh();   
}

/* --Methode-- */
void PIPixmapGen::SetRGBArray(PIPixRGBArray *rgba, CMapId cmapid, bool refr, int ox, int oy)
{
if (rgba == NULL) return;
int quantum = 8;
if (cmapid == CMAP_RGB216)  quantum = 6;
else if (cmapid == CMAP_RGB4096) quantum = 16;
else cmapid = CMAP_RGB512;
SetColMapId(cmapid, false);
PIPixColIdx * pixc = new PIPixColIdx;
pixc->AllocateByte(rgba->XSize(), rgba->YSize());
for(int j=0; j<rgba->YSize(); j++) 
  for(int i=0; i<rgba->XSize(); i++) {
  	PIPixRGB vv = (*rgba)(i,j);
  	int r = (int)vv.red*quantum/256;
  	int g = (int)vv.green*quantum/256;
  	int b = (int)vv.blue*quantum/256;
    pixc->GetShort(i,j) = (unsigned short)((b*quantum+g)*quantum+r);
  }
SetPixmap(pixc, refr, ox, oy);
fgownpmap = true;
return;  
}

/* --Methode-- */
void PIPixmapGen::SetColMap(PIColorMap* cmp, bool refr)
{
if (!cmp)  return;
if ( (cmp->Type() == cmap->Type()) && (cmp->Type() != CMAP_OTHER) 
     && (cmp->IsColorIndexReversed() == cmap->IsColorIndexReversed()) ) return;
if (cmap) delete cmap;
cmap = new PIColorMap(*cmp);
if (refr)  Refresh();  
}

/* --Methode-- */
void PIPixmapGen::SetColMapId(CMapId cmapid, bool revidx, bool refr)
{
if (!cmap || (cmap->Type() != cmapid) || (cmapid == CMAP_OTHER) 
    || (cmap->IsColorIndexReversed() != revidx) ) {  
  if (cmap) delete cmap;
  cmap = new PIColorMap(cmapid);
  cmap->ReverseColorIndex(revidx);
  }
if (refr)  Refresh();  
}


/* --Methode-- */
void  PIPixmapGen::But1Press(int x, int y)
{
mPpos[0] = x-ofx;  mPpos[1] = y-ofy;  
if (Msg())  Send(Msg(), PIMsg_Click, mPpos);
return;
}



// Fin des methodes de la classe 


