/*
 *  pibwdgquartz.h
 *  PI
 *
 *  Created by Bruno MANSOUX on 19/09/08.
 *
 */

#ifndef PIBWDGQUARTZ_H_SEEN
#define PIBWDGQUARTZ_H_SEEN

#include "pisysdep.h"
#include "pibwdggen.h"

#include "pigraphquartz.h"
#include "pigraphps.h"

/*
static const EventTypeSpec basewdgSpec[] = {
 											 { kEventClassWindow, kEventWindowClose},
 											 { kEventClassWindow, kEventWindowResizeCompleted},
 											 { kEventClassWindow, kEventWindowDrawContent},
											 { kEventClassWindow, kEventWindowBoundsChanged },
											 { kEventClassHIObject, kEventHIObjectConstruct },
											 { kEventClassHIObject, kEventHIObjectInitialize },
											 { kEventClassHIObject, kEventHIObjectDestruct },
											  { kEventClassControl, kEventControlDraw},
											  { kEventClassControl, kEventControlClick},
											  { kEventClassControl, kEventControlBoundsChanged},
											  { kEventClassControl, kEventControlOwningWindowChanged },
											  { kEventClassControl, kEventControlInitialize },
											  { kEventClassControl, kEventControlGetPartRegion },
											  { kEventClassControl, kEventControlHitTest }
											 };

*/

static const EventTypeSpec basewdgSpec[] = {{ kEventClassControl, kEventControlDraw}};


class PIBaseWdgQuartz : public PIBaseWdgGen
{

public:
// Les methodes ...

                     PIBaseWdgQuartz(PIContainerGen *par, const char *nom,
                                int sx=10, int sy=10, int px=0, int py=0);
  virtual            ~PIBaseWdgQuartz();

  virtual void       FinishCreate();   // appele par la fenetre mere, apres XtRealize()

//  Activation des evenements   
  virtual void       ActivatePtrCross();
  virtual void       ActivateButton(int bid);
  virtual void       ActivateMove(int bid);
  virtual void       ActivateKeyboard();

//  Divers : couleur de fond, Effacement fenetre,  forme de la souris
  virtual void       SelPointerShape(PIPointer ptr=PI_ArrowPointer);
  virtual PIPointer  GetPointerShape();
  virtual void       AssignKeyboard();

// Acces aux caracteristiques du dernier evenement 
  virtual void       GetLastEventInfo(PIKeyModifier& kmod, unsigned long& tm);

// On redefinit IsVisible() pour tenir compte de l appel a FinsihCreate  
  virtual bool       IsVisible();

//  Fonction qui doit etre appelee pour rafraichir la fenetre 
  virtual void       Refresh();

//  Appel depuis le PIXtBaseWidget uniquement (ExposeEvt de Xt )
  virtual void       eXposeProcess(CGContextRef cg, int x0, int y0, int dx, int dy);
 
protected:
  void               Init();
  PIPointer          mPtrS;
// pour s'assurer que le bon FinishCreate() est appele - pb lie aux tables de fonctions
// virtuelles des classes qui sont remplies au fur et a mesure des constructeurs
  bool               bwx_finishDone; 
};

typedef PIBaseWdgQuartz PIBaseWdg;

#endif /* PIBWDGQUARTZ_H_SEEN */
