/*
 *  pibwdgquartz.cpp
 *  PI
 *
 *  Created by Bruno MANSOUX on 19/09/08.
 *
 */

#include "pibwdgquartz.h"
#include "PIContainerQuartz.h"

OSStatus BaseWdgQuartzEventHandler (EventHandlerCallRef myHandler,EventRef event, void *userData);

PIBaseWdgQuartz::PIBaseWdgQuartz(PIContainerGen *par, const char *nom, int sx, int sy, int px, int py)
: PIBaseWdgGen(par,nom,sx,sy,px,py)
{
	HIRect localHIRect;
	HIViewRef rootView;
	HIViewRef contentView;
	OSStatus err;
	
	rootView = ((PIWdg*)par)->GetHIViewRef();
	err = HIViewGetBounds (rootView, &localHIRect);
												
	err = HIScrollViewCreate(kHIScrollViewOptionsVertScroll | kHIScrollViewOptionsHorizScroll, &wdgHIView);
	err += HIViewSetVisible (wdgHIView, true);	
	
	err += HIViewFindByID(rootView, kHIViewWindowContentID, &contentView);
	err += HIViewAddSubview (contentView, wdgHIView);

	err += HIViewGetBounds (wdgHIView, &localHIRect);
	
	localHIRect.origin.x = (float)px;
	localHIRect.origin.y	= (float)py;
	localHIRect.size.width = (float)sx; 
	localHIRect.size.height = (float)sy;
	
	err = HIViewSetFrame (wdgHIView, &localHIRect);
	
	err += HIViewGetFrame (wdgHIView, &localHIRect);
	
	printf("PIBaseWdgQuartz::PIBaseWdgQuartz Set Frame (%g %g) [%g %g] err : %d \n",
											localHIRect.origin.x, localHIRect.origin.y,
											localHIRect.size.width, localHIRect.size.height,
											err);

	err = InstallEventHandler (GetControlEventTarget (wdgHIView),
								NewEventHandlerUPP (BaseWdgQuartzEventHandler),
								GetEventTypeCount (basewdgSpec),
								(const EventTypeSpec*)&basewdgSpec,
								(void *) this,
								NULL);

	HIViewRender(wdgHIView);

	mWGrC = new PIGraphicWin(this);
}

/* --Methode-- */
PIBaseWdgQuartz::~PIBaseWdgQuartz()
{
}

/* --Methode-- */
void PIBaseWdgQuartz::FinishCreate()
{
}

/* --Methode-- */
void PIBaseWdgQuartz::ActivatePtrCross()
{
}
 
/* --Methode-- */
void PIBaseWdgQuartz::ActivateButton(int bid)
{
}
 
/* --Methode-- */
void PIBaseWdgQuartz::ActivateMove(int bid)
{
}
 
/* --Methode-- */
void PIBaseWdgQuartz::ActivateKeyboard()
{
}
 
/* --Methode-- */
void PIBaseWdgQuartz::SelPointerShape(PIPointer ptr)
{
}
 
/* --Methode-- */
PIPointer PIBaseWdgQuartz::GetPointerShape()
{
	return PI_ArrowPointer;
}
 
/* --Methode-- */
void PIBaseWdgQuartz::AssignKeyboard()
{
}

/* --Methode-- */
void PIBaseWdgQuartz::GetLastEventInfo(PIKeyModifier& kmod, unsigned long& tm)
{
}

/* --Methode-- */
bool PIBaseWdgQuartz::IsVisible()
{
	return true;
}

/* --Methode-- */
void PIBaseWdgQuartz::Refresh()
{
	printf("PIBaseWdgQuartz::Refresh ");
	EventRef	rEvent;
	OSStatus err;
	
	err = CreateEvent( NULL,  kEventClassControl, kEventControlDraw,
				GetCurrentEventTime(), kEventAttributeNone, &rEvent );
	SetEventParameter( rEvent, kEventParamCGContextRef, typeCGContextRef, sizeof (CGContextRef), mWGrC->GetCGContext());

	SendEventToEventTarget(rEvent, GetControlEventTarget (wdgHIView));
	
	HIRect hiRect;
	HIViewGetFrame(wdgHIView, &hiRect);

	CGContextRestoreGState (mWGrC->GetCGContext());
	printf(" cg : %lx ox : %g oy : %g width : %g height : %g \n",
			mWGrC->GetCGContext(), hiRect.origin.x, hiRect.origin.y, hiRect.size.width, hiRect.size.height);
	// mWGrC->SetGCRect(hiRect.origin.x, hiRect.origin.y, hiRect.size.width, hiRect.size.height);	
	// Draw(mWGrC, 0, 0, XSize(), YSize());

	return;
}

/* --Methode-- */
void PIBaseWdgQuartz::eXposeProcess(CGContextRef cg, int x0, int y0, int dx, int dy)
{
	printf("PIBaseWdgQuartz::ExposeProcess \n");
	CGContextSaveGState(cg);
	mWGrC->SetCGContext(cg);
	mWGrC->SetCTM(CGContextGetCTM(cg));
	Draw(mWGrC, x0, y0, dx, dy);

	return;
}
 
/* ============================================================================================================ */
/* ============================================================================================================ */
static int counterDraw = 0;
// Handler
OSStatus BaseWdgQuartzEventHandler (EventHandlerCallRef myHandler, EventRef event, void *userData)
{
	OSStatus status = noErr;
	
	counterDraw++;
	printf(" BaseWdgQuartzEventHandler (%d) : ", counterDraw);
	PIGetEventName(event);

	PIBaseWdgQuartz* wdg = (PIBaseWdgQuartz*) userData;

	CGContextRef cg;
		
    status = GetEventParameter (event, kEventParamCGContextRef, typeCGContextRef, NULL, sizeof (CGContextRef), NULL, &cg);

	if (status != noErr)
	{
		printf(" err = %d \n",status);
	}
	else
	{	
		// wdg->SetQuartzCGContext(cg);
		HIViewRef view = wdg->GetHIViewRef();
		HIRect hiRect;
		HIViewGetFrame(view, &hiRect);
		// Pour le moment on rafraichit toute la vue
		int ox = (int)(hiRect.origin.x);
		int oy = (int)(hiRect.origin.x);
		int dx = (int)(hiRect.size.width); 
		int dy = (int)(hiRect.size.height);
		printf(" BaseWdgQuartzEventHandler cg : %lx [%d %d] Frame [%d, %d] \n", (unsigned long)cg, ox, oy, dx, dy);
		wdg->eXposeProcess(cg, 0 , 0, dx, dy);
	}

	return status;
}
