// This may look like C code, but it is really -*- C++ -*-
// Module PI : Peida Interactive     PIGraphicX
// Trace graphiques- Implementation X11  R. Ansari  97
// LAL (Orsay) / IN2P3-CNRS  DAPNIA/SPP (Saclay) / CEA

#ifndef PIGRAPHICX_H_SEEN
#define PIGRAPHICX_H_SEEN

#include "pisysdep.h"
#include "pigraphgen.h"

class PIGraphicX : public PIGraphicGen
{
public:
                     PIGraphicX(PIWdg* wdg);
                     PIGraphicX(PIScreenBuffer* grb);
  virtual           ~PIGraphicX();

  virtual int        kind();

//  Trace graphiques
  virtual void       Erase(PIGrCoord x0, PIGrCoord y0, PIGrCoord dx, PIGrCoord dy);
  virtual void       DrawString(PIGrCoord x, PIGrCoord y, const char* s, unsigned long pos = 0);
  virtual void       DrawOpaqueString(PIGrCoord x, PIGrCoord y, const char* s, unsigned long pos = 0);
  virtual void       DrawLine(PIGrCoord x1, PIGrCoord y1, PIGrCoord x2, PIGrCoord y2);
  virtual void       DrawBox(PIGrCoord x0, PIGrCoord y0, PIGrCoord dx, PIGrCoord dy);
  virtual void       DrawFBox(PIGrCoord x0, PIGrCoord y0, PIGrCoord dx, PIGrCoord dy);
  virtual void       DrawCircle(PIGrCoord x0, PIGrCoord y0, PIGrCoord r);
  virtual void       DrawFCircle(PIGrCoord x0, PIGrCoord y0, PIGrCoord r);
  virtual void       DrawOval(PIGrCoord x0, PIGrCoord y0, PIGrCoord dx, PIGrCoord dy);
  virtual void       DrawFOval(PIGrCoord x0, PIGrCoord y0, PIGrCoord dx, PIGrCoord dy);
  virtual void       DrawPolygon(PIGrCoord *x, PIGrCoord *y, int n, bool cinc=true);  
  virtual void       DrawFPolygon(PIGrCoord *x, PIGrCoord *y, int n, bool cinc=true);  
  virtual void       DrawArc(PIGrCoord x0, PIGrCoord y0, PIGrCoord dx, PIGrCoord dy,
                             double degdeb, double deltadeg);
  virtual void       DrawFArc(PIGrCoord x0, PIGrCoord y0, PIGrCoord dx, PIGrCoord dy, 
                              double degdeb, double deltadeg);
  virtual void       DrawMarker(PIGrCoord x0, PIGrCoord y0);
  virtual void       DrawMarkers(PIGrCoord *x, PIGrCoord *y, int n);
  virtual void       DrawPixmap(PIGrCoord x, PIGrCoord y, unsigned char *pix, 
                                int sx, int sy, PIColorMap* cmap);

// Modifications attributs graphiques
  virtual void       SelForeground(PIColors col=PI_Black);
  virtual void       SelBackground(PIColors col=PI_White);
  virtual void       SelForeground(PIColorMap& cmap, int cid);
  virtual void       SelBackground(PIColorMap& cmap, int cid);
  virtual void       SelGOMode(PIGOMode mod=PI_GOCopy);
  virtual void       SelLine(PILineAtt const& att);
  virtual void       SelMarker(int msz=3, PIMarker mrk=PI_DotMarker);

// Modifications de fonte
  virtual void	     SelFont(PIFont & fnt);
  virtual void       SelFont(PIFontSize sz=PI_NormalSizeFont, 
                             PIFontAtt att=PI_RomanFont);
  virtual void       SelFontSzPt(int npt=12, PIFontAtt att=PI_RomanFont);

// Selection de zone de trace (clip)
  virtual void       SetClipRectangle(PIGrCoord x0, PIGrCoord y0, PIGrCoord dx, PIGrCoord dy);
  virtual void       ClearClipRectangle();

// Acces aux attributs graphiques 
  virtual PIColors   GetForeground();
  virtual PIColors   GetBackground();
  virtual PIGOMode   GetGOMode();
  virtual PIFontAtt  GetFontAtt();
  virtual int        GetFontSize();
  virtual PILineAtt  GetLineAtt();
  virtual PIMarker   GetMarker();
  virtual int        GetMarkerSize();

// Sauvegarde des attributs graphiques 
  virtual void       SaveGraphicAtt();
  virtual void       RestoreGraphicAtt();

//  Pour initialiser mWId apres creation de fenetre
  virtual void	     TerminateInit();

//  Pour recuperer le pixcol d une couleur  (pour X) 
  static PIXColor    GetPixelValueforColor(PIColors col);

protected:
  static void    GlInit();
  void           Init();
  void           SelectFont(int isz, int jat);
  inline  GC     DefGC() { return mDefGC; }
  inline SysDWdg MyWdg()  {return(myWdg->XtWdg()); }
  inline void    SelectBCol(PIXColor col) 
    {XSetBackground(mDisp, DefGC(), col);  mBCol = PI_ColorFromMap; mBCfMap = col; }
  inline void    SelectFCol(PIXColor col) 
    {XSetForeground(mDisp, DefGC(), col);  mFCol = PI_ColorFromMap; mFCfMap = col; }

  bool           SetupMrkGC();
  void           MrkDrawPolygon(XPoint* pxp, int n, bool cinc);
  void           MrkDrawFPolygon(XPoint* pxp, int n, bool cinc);
  void	         DrawVerticalString(int x, int y, const char* s, unsigned long pos, bool imgs=false);

//  Structure et identificateur XWindow  associe
  GC mDefGC;
  GC mMrkGC;
  bool mFgMrkGCOK;
  Display* mDisp;  // Display X associe
  Drawable mWId;   // Identificateur Window/Drawable X

  PIColors  mFCol, mBCol;
  PIGOMode mGOm;
  PIFontAtt mFAtt;
  PILineAtt mLAtt;
  int mFSize;
  XFontStruct *mFSt;
  PIMarker mMrk;
  int mMrkSz;
  PIXColor mFCfMap, mBCfMap;
  PIXColor sFCfMap, sBCfMap;
};

typedef PIGraphicX PIGraphicWin;

#endif
