/*
 *  PIWindowQuartz.cpp
 *  PI
 *
 *  Created by Bruno MANSOUX on Tue Apr 13 2004.
 *
 */

#include "PIWindowQuartz.h"

PIWindowQuartz::PIWindowQuartz(PIMsgHandler *par, const char *nom, PIWindowKind k, int sx, int sy, int px, int py)
:PIWindowGen(par, nom, k, sx, sy, px, py) 
{
    OSStatus err = 0;
    WindowAttributes windowAttributes;
	HIRect bounds;
	
    SetRect(&wdgRect,px,py,px+sx,py+sy);
	windowAttributes = kWindowStandardDocumentAttributes | kWindowCompositingAttribute | kWindowStandardHandlerAttribute | kWindowLiveResizeAttribute;
	
	err = CreateNewWindow (kDocumentWindowClass, windowAttributes, &wdgRect, &wRef);

    if (err)
        printf ("PIWindowQuartz Create Err = %d \n",err);
    
	CFStringRef cfsrLabel = CFStringCreateWithCString(kCFAllocatorDefault,nom,kCFStringEncodingMacRoman);
    err = SetWindowTitleWithCFString (wRef, cfsrLabel);

	wdgHIView = HIViewGetRoot(wRef);
	HIViewGetBounds (wdgHIView, &bounds);

//////
/*
 CGRect myBoundingBox;// 1
	
    myBoundingBox = CGRectMake (0, 0, myWidth, myHeight);// 2
    myBitmapContext = MyCreateBitmapContext (400, 300);// 3
    // ********** Your drawing code here ********** // 4
    CGContextSetRGBFillColor (myBitmapContext, 1, 0, 0, 1);
    CGContextFillRect (myBitmapContext, CGRectMake (0, 0, 200, 100 ));
    CGContextSetRGBFillColor (myBitmapContext, 0, 0, 1, .5);
    CGContextFillRect (myBitmapContext, CGRectMake (0, 0, 100, 200 ));
    myImage = CGBitmapContextCreateImage (myBitmapContext);// 5
    CGContextDrawImage(myContext, myBoundingBox, myImage);// 6
    char *bitmapData = CGBitmapContextGetData(myBitmapContext); // 7
    CGContextRelease (myBitmapContext);// 8
    if (bitmapData) free(bitmapData); // 9
    CGImageRelease(myImage);
*/	
///////

	
	printf("PIWindowQuartz::PIWindowQuartz Window View Bounds (%g %g) [%g %g] \n",
											bounds.origin.x, bounds.origin.y,
											bounds.size.width, bounds.size.height);
	InstallStandardEventHandler(GetWindowEventTarget(wRef)); /* installs the default */	
}

PIWindowQuartz::~PIWindowQuartz()
{

}
/*
 
CGContextRef PIWindowQuartz::MyCreateBitmapContext (int pixelsWide,
									int pixelsHigh)
{
    CGContextRef    context = NULL;
    CGColorSpaceRef colorSpace;
    void *          bitmapData;
    int             bitmapByteCount;
    int             bitmapBytesPerRow;
	
    bitmapBytesPerRow   = (pixelsWide * 4);// 1
    bitmapByteCount     = (bitmapBytesPerRow * pixelsHigh);
	
    colorSpace = CGColorSpaceCreateWithName(kCGColorSpaceGenericRGB);// 2
    bitmapData = calloc( bitmapByteCount );// 3
    if (bitmapData == NULL)
    {
        fprintf (stderr, "Memory not allocated!");
        return NULL;
    }
    context = CGBitmapContextCreate (bitmapData,// 4
									 pixelsWide,
									 pixelsHigh,
									 8,      // bits per component
									 bitmapBytesPerRow,
									 colorSpace,
									 kCGImageAlphaPremultipliedLast);
    if (context== NULL)
    {
        free (bitmapData);// 5
        fprintf (stderr, "Context not created!");
        return NULL;
    }
    CGColorSpaceRelease( colorSpace );// 6
	
    return context;// 7
}
*/
////

void PIWindowQuartz::SetSize(int sx, int sy)
{
    SizeWindow (wRef, sx, sy, true);
    return;
}

void PIWindowQuartz::SetPos(int px, int py)
{
    MoveWindow (wRef, px, py, false);
    return;
}

void PIWindowQuartz::Manage()
{
    return;	
}

void PIWindowQuartz::UnManage()
{
	HideWindow(wRef);
    return;
}

bool PIWindowQuartz::IfManaged()
{
    return true;
}
 
bool PIWindowQuartz::IsVisible()
{
    return (IsWindowVisible(wRef));
}

//  Fonction qui doit etre appelee pour rafraichir la fenetre 
void PIWindowQuartz::Refresh()
{
	printf("PIWindowQuartz::Refresh \n");
    SetPortWindowPort(wRef);
    BeginUpdate(wRef);
	EraseRect(GetWindowPortBounds(wRef, &wdgRect));
    DrawControls(wRef);
    DrawGrowIcon(wRef);
	// HIViewSetNeedsDisplay(wdgHIView, true);
    EndUpdate(wRef);
    ShowWindow (wRef);
    return ;
}

void PIWindowQuartz::Show()
{
	Refresh();
}

//  Pour rendre un composant graphique (PIWdg) sensible/insensible 
void PIWindowQuartz::SetSensitive()
{
    ActivateWindow (wRef, true);
    return;
}

void PIWindowQuartz::SetUnSensitive()
{
    ActivateWindow (wRef, false);
    return;
}

bool PIWindowQuartz::IfSensitive()
{
    return (IsWindowActive(wRef));
}

//  Gestion des EventHandler
void PIWindowQuartz::AddEventHandler(PIEventHandler* evh, unsigned long evtmask, bool ad)
{
/*
    InstallWindowEventHandler (contH, 
                                NewEventHandlerUPP (evh),
                                GetEventTypeCount(evtmask),
                                evtmask,
                                contH,
                                NULL);
                                
*/
    return;
}

void PIWindowQuartz::RemoveEventHandler(PIEventHandler* evh)
{
    RemoveEventHandler(evh);
    return;
}

// En public, pour permettre l'acces depuis call-back Xt
void PIWindowQuartz::CallDrawHandlers(int x0, int y0, int dx, int dy)
{
    return;
}

void PIWindowQuartz::CallEventHandlers(unsigned long evt, int px, int py,
                                    int k, int km, unsigned long tm)
{
    return;
}
