/*
 *  pibwdgquartz.cpp
 *  PI
 *
 *  Created by Bruno MANSOUX on 19/09/08.
 *
 */

#include "pibwdgquartz.h"
#include "PIContainerQuartz.h"

OSStatus BaseWdgQuartzEventHandler (EventHandlerCallRef myHandler,EventRef event, void *userData);

PIBaseWdgQuartz::PIBaseWdgQuartz(PIContainerGen *par, const char *nom, int sx, int sy, int px, int py)
: PIBaseWdgGen(par,nom,sx,sy,px,py)
{

 HIRect localHIRect;
	HIViewRef rootView;
	HIViewRef contentView;
	OSStatus err;
	fName = nom;
	
	rootView = ((PIWdg*)par)->GetHIViewRef();
	err = HIViewGetBounds (rootView, &localHIRect);

	err = HIScrollViewCreate(kHIScrollViewOptionsVertScroll | kHIScrollViewOptionsHorizScroll, &wdgHIView);
	err += HIViewSetVisible (wdgHIView, true);	
	
	err += HIViewFindByID(rootView, kHIViewWindowContentID, &contentView);
	err += HIViewAddSubview (contentView, wdgHIView);

	err += HIViewGetBounds (wdgHIView, &localHIRect);
	
	localHIRect.origin.x = (float)px;
	localHIRect.origin.y	= (float)py;
	localHIRect.size.width = (float)sx; 
	localHIRect.size.height = (float)sy;
	
	err = HIViewSetFrame (wdgHIView, &localHIRect);
	
	err += HIViewGetFrame (wdgHIView, &localHIRect);
	
	printf("PIBaseWdgQuartz::PIBaseWdgQuartz Set Frame (%g %g) [%g %g] err : %d nom:%s\n",
											localHIRect.origin.x, localHIRect.origin.y,
											localHIRect.size.width, localHIRect.size.height,
											err,nom);

	err = InstallEventHandler (GetControlEventTarget (wdgHIView),
								NewEventHandlerUPP (BaseWdgQuartzEventHandler),
								GetEventTypeCount (basewdgSpec),
								(const EventTypeSpec*)&basewdgSpec,
								(void *) this,
								NULL);

	HIViewRender(wdgHIView);
	FinishCreate();
	mWGrC = new PIGraphicWin(this);
}

/* --Methode-- */
PIBaseWdgQuartz::~PIBaseWdgQuartz()
{
}

/* --Methode-- */
void PIBaseWdgQuartz::FinishCreate()
{
}

/* --Methode-- */
void PIBaseWdgQuartz::ActivatePtrCross()
{
}
 
/* --Methode-- */
void PIBaseWdgQuartz::ActivateButton(int bid)
{
}
 
/* --Methode-- */
void PIBaseWdgQuartz::ActivateMove(int bid)
{
}
 
/* --Methode-- */
void PIBaseWdgQuartz::ActivateKeyboard()
{
}
 
/* --Methode-- */
void PIBaseWdgQuartz::SelPointerShape(PIPointer ptr)
{
}
 
/* --Methode-- */
PIPointer PIBaseWdgQuartz::GetPointerShape()
{
	return PI_ArrowPointer;
}
 
/* --Methode-- */
void PIBaseWdgQuartz::AssignKeyboard()
{
}

/* --Methode-- */
void PIBaseWdgQuartz::GetLastEventInfo(PIKeyModifier& kmod, unsigned long& tm)
{
}

/* --Methode-- */
bool PIBaseWdgQuartz::IsVisible()
{
	return true;
}

/* --Methode-- */
void PIBaseWdgQuartz::Refresh()
{
//	return;
	printf("---->> PIBaseWdgQuartz::Refresh -%s- context:%lx\n",fName,mWGrC->GetCGContext());
	EventRef	rEvent;
	OSStatus err;
	
	err = CreateEvent( NULL,  kEventClassControl, kEventControlDraw,
				GetCurrentEventTime(), kEventAttributeNone, &rEvent );
	SetEventParameter( rEvent, kEventParamCGContextRef, typeCGContextRef, sizeof (CGContextRef), mWGrC->GetCGContext());

	SendEventToEventTarget(rEvent, GetControlEventTarget (wdgHIView));
	
	HIRect hiRect;
	HIViewGetFrame(wdgHIView, &hiRect);

	printf(" cg : %lx ox : %g oy : %g width : %g height : %g \n",
			mWGrC->GetCGContext(), hiRect.origin.x, hiRect.origin.y, hiRect.size.width, hiRect.size.height);
	// mWGrC->SetGCRect(hiRect.origin.x, hiRect.origin.y, hiRect.size.width, hiRect.size.height);	
	// Draw(mWGrC, 0, 0, XSize(), YSize());

	return;
}

/* --Methode-- */
void PIBaseWdgQuartz::eXposeProcess(CGContextRef cg, int x0, int y0, int dx, int dy)
{
	printf("PIBaseWdgQuartz::ExposeProcess -%s- to x:%d y:%d dx:%d dy:%d\n",fName,x0,y0,dx,dy);
	if (mWGrC->GetCGContext() == NULL) {
		mWGrC->SetCGContext(cg);
		printf("PIBaseWdgQuartz::ExposeProcess CHANGE context to %lx\n",cg);
		mWGrC->SetCTM(CGContextGetCTM(cg));
	}
	printf("PIBaseWdgQuartz::ExposeProcess set CTM to %lx\n",cg);
	CGContextSaveGState(mWGrC->GetCGContext());
	Draw(mWGrC, x0, y0, dx, dy);
//	CGContextRestoreGState (cg);
	CGContextRestoreGState (mWGrC->GetCGContext());

	return;
}
 
/* ============================================================================================================ */
/* ============================================================================================================ */
static int counterDraw = 0;
// Handler
OSStatus BaseWdgQuartzEventHandler (EventHandlerCallRef myHandler, EventRef event, void *userData)
{
	OSStatus status = noErr;
	
	counterDraw++;
	PIGetEventName(event);

	PIBaseWdgQuartz* wdg = (PIBaseWdgQuartz*) userData;
	printf("\n BaseWdgQuartzEventHandler -%s- (%d) : ", wdg->fName,counterDraw);
	printf("\n");

	CGContextRef cg;
	WindowRef           window;
    Rect                bounds;
	if (!wdg)
        return status;
	
    status = GetEventParameter (event, kEventParamCGContextRef, typeCGContextRef, NULL, sizeof (CGContextRef), NULL, &cg);

	switch(GetEventClass(event))
    {
/*        case kEventClassTablet:
        case kEventClassMouse:
            if (w->handleMouseEvent(event))
                result = noErr;
            break;
        case kEventClassKeyboard:
            if (w->handleKeyboardEvent(event))
                result = noErr;
            break;
            
*/        case kEventClassWindow: {
			
            switch (GetEventKind(event))
			{
				case kEventWindowBoundsChanging:
					// left the code for live-resizing, but it is not used, because of window-refreshing issues...
					GetEventParameter( event, kEventParamCurrentBounds, typeQDRectangle, NULL, sizeof(Rect), NULL, &bounds );
					
//					wdg->adaptResize(bounds.left, bounds.top, bounds.right - bounds.left, bounds.bottom - bounds.top);
//					wdg->requestRedraw();
					status = noErr;
					break;
					
				case kEventWindowBoundsChanged:
					InvalWindowRect(window, GetWindowPortBounds(window, &bounds));
					GetWindowBounds(window, kWindowContentRgn, &bounds);
//					wdg->adaptResize(bounds.left, bounds.top, bounds.right - bounds.left, bounds.bottom - bounds.top);
					status = noErr;
					break;
                    
				case kEventWindowClose:
//					wdg->requestClose();
					status = noErr;
					break;
					
				default: 
					break;
			}
		break;	
		}
		case kEventClassControl : {			
			case kEventControlDraw: {
				// wdg->SetQuartzCGContext(cg);
				HIViewRef view = wdg->GetHIViewRef();
				HIRect hiRect;
				HIViewGetFrame(view, &hiRect);
				// Pour le moment on rafraichit toute la vue
				int ox = (int)(hiRect.origin.x);
				int oy = (int)(hiRect.origin.x);
				int dx = (int)(hiRect.size.width); 
				int dy = (int)(hiRect.size.height);
				printf("-->> PIbWdgquartz::BaseWdgQuartzEventHandler -%s- cg : %lx [%d %d] Frame [%d, %d] \n", wdg->fName,(unsigned long)cg, ox, oy, dx, dy);
			
				HIRect      bounds;
				HIViewGetBounds ((HIViewRef) userData, &bounds);
				printf("-->> PIbWdgquartz::BaseWdgQuartzEventHandler BOUNDS [%f %f] SIZE [%f, %f] \n",hiRect.origin.x,hiRect.origin.y,hiRect.size.width,hiRect.size.height);
				//		err = HIViewSetFrame (wdgHIView, &localHIRect);
				
				wdg->eXposeProcess(cg, 0 , 0, dx, dy);
			}
			break;
		}
			break;	
        default:
            printf("unknown: %g\n",GetEventClass(event));
            break;
    }
	
	/////
	
	
	
	if (status != noErr)
	{
		printf(" err = %d \n",status);
	}
	else
	{	
/*
 // wdg->SetQuartzCGContext(cg);
		HIViewRef view = wdg->GetHIViewRef();
		HIRect hiRect;
		HIViewGetFrame(view, &hiRect);
		// Pour le moment on rafraichit toute la vue
		int ox = (int)(hiRect.origin.x);
		int oy = (int)(hiRect.origin.x);
		int dx = (int)(hiRect.size.width); 
		int dy = (int)(hiRect.size.height);
		printf(" BaseWdgQuartzEventHandler cg : %lx [%d %d] Frame [%d, %d] \n", (unsigned long)cg, ox, oy, dx, dy);
		
		HIRect      bounds;
		HIViewGetBounds ((HIViewRef) userData, &bounds);
		printf(" BaseWdgQuartzEventHandler BOUNDS [%f %f] SIZE [%f, %f] \n",hiRect.origin.x,hiRect.origin.y,hiRect.size.width,hiRect.size.height);
//		err = HIViewSetFrame (wdgHIView, &localHIRect);
		
		wdg->eXposeProcess(cg, 0 , 0, dx, dy);
*/
	}

	return status;
}
