#ifndef PISTDWDGMOSX_H_SEEN
#define PISTDWDGMOSX_H_SEEN

#include "piwdgquartz.h"
#include "pistdwdggen.h"
#include "PIContainerQuartz.h"

class PILabelQuartz : public PILabelGen
{
public:
	PILabelQuartz(PIContainerGen* par, const char* nom,int sx=10, int sy=10, int px=0, int py=0);
	
	~PILabelQuartz();
	
	virtual void SetLabel(string const& sLabel);
	
protected:
	CFStringRef cfsrLabel;
	ControlRef contH;
};

class PITextQuartz : public PITextGen
{
public:
	PITextQuartz(PIContainerGen *par, const char *nom, 
				int sx=10, int sy=10, int px=0, int py=0);

	PITextQuartz(PIContainerGen* par, const char* nom, bool vsb, bool hsb,
         		     int sx=100, int sy=100, int px=0, int py=0);
  virtual           ~PITextQuartz();
  virtual void      SetText(string const&);
  virtual string    GetText() const;

  virtual void      SetMutiLineMode(bool mlm=false);
  virtual void      SetTextEditable(bool te=true);

  virtual void		SetMsg(PIMessage msg=0);
  	
protected:
	CFStringRef unicodeText;
	ControlRef contH;
};


class PIHITextViewQuartz : public PITextGen
{
public:
	PIHITextViewQuartz(PIContainerGen *par, const char *nom, 
				int sx=10, int sy=10, int px=0, int py=0);

	PIHITextViewQuartz(PIContainerGen* par, const char* nom, bool vsb, bool hsb,
         		     int sx=100, int sy=100, int px=0, int py=0);
  virtual           ~PIHITextViewQuartz();
  virtual void      SetText(string const&);
  virtual string    GetText() const;

  virtual void      SetMutiLineMode(bool mlm=false);
  virtual void      SetTextEditable(bool te=true);

  virtual void		SetMsg(PIMessage msg=0);
  	
protected:
	UniChar* uniChars;
	CFIndex textLength;
	HIViewRef outTextView;
	HIRect hiRect;
	ControlRef fUserPane;
	Rect userPaneRect;
};

class PIButtonQuartz : public PIButtonGen
{
public:
    PIButtonQuartz(PIContainerQuartz *par, const char *nom, PIMessage msg = PIMsg_Click, 
					int sx=10, int sy=10, int px=0, int py=0);
    virtual	~PIButtonQuartz();
	virtual void       ActivatePress(bool acp=false);
	virtual void       SetLabel(string const&);

private:
	ControlActionUPP _actionProc;
};

class PICheckBoxQuartz : public PICheckBoxGen
{
public:
    PICheckBoxQuartz(PIContainerQuartz *par, const char *nom, PIMessage msg = PIMsg_Click, 
					int sx=10, int sy=10, int px=0, int py=0);
    virtual	~PICheckBoxQuartz();
	virtual void	SetState(bool acp=false);
	virtual bool	GetState();

private:
	ControlActionUPP _actionProc;
	int _state;
};

class PIRadioQuartz : public PIWdg
{
public:
    PIRadioQuartz(PIContainerQuartz *par, const char *nom, PIMessage msg = PIMsg_Click, 
					int sx=10, int sy=10, int px=0, int py=0, int initialValue =0);
    virtual	~PIRadioQuartz();

private:
	ControlActionUPP _actionProc;
	int _state;
};

class PIRadioGroupQuartz : public PIWdg
{
public:
    PIRadioGroupQuartz(PIContainerQuartz *par, const char *nom, PIMessage msg = PIMsg_Click, 
					int sx=10, int sy=10, int px=0, int py=0);
    virtual	~PIRadioGroupQuartz();
	void AddRadioButton(PIRadioQuartz* piRadio);

private:
	int _state;
};

class PIScrollBarQuartz : public PIScrollBarGen
{
public:
	PIScrollBarQuartz(PIContainerQuartz *par, const char *nom, PIMessage msg = PIMsg_Click, 
					  int dir=kSDirUpDown, int sx=10, int sy=100, int px=0, int py=0);
	void SetMinMax(int, int);
	void SetSlSize(int);
	void SetValue(int);
	void ActivateDrag(bool);
    void GetMinMax(int&, int&);
	void GetMinMax(int, int);
	int GetValue();
	int GetSlSize();

};

// INTERFACES

typedef PIRadioGroupQuartz PIRadioGroup;
typedef PIRadioQuartz PIRadio;
typedef PICheckBoxQuartz PICheckBox;
typedef PIButtonQuartz PIButton;
typedef PILabelQuartz PILabel;
typedef PITextQuartz PIText;
typedef PIHITextViewQuartz PITextView;
typedef PIScrollBarQuartz PIScrollBar;

#endif