#include <stdlib.h>
#include <stdio.h>
#include <iostream>

#include "sopnamsp.h"
#include "pisysdep.h"

#include PIAPP_H
#include PIMENU_H 
#include PISTDWDG_H 
#include PIWIN_H
#ifdef __PIWQUARTZ__
#include <pistdwdgquartz.h>
#else
#include <pistdwdgx.h>
#endif

//  ----- Declaration de la classe ArgsWind : Fenetre de dialogue -------
class ArgsWind : public PIWindow {
public :
                ArgsWind(PIApplication *par);
                ~ArgsWind();
  virtual void  Process(PIMessage msg, PIMsgHandler* sender, void* data=NULL);

private:
  PILabel  * mLab[2];
  PIButton * mBut[2];
  PIText * mText[2];
  };

//  ----- Declaration de notre classe PIApplication (PITApp) -------
class PITApp : public PIApplication {
public:
     PITApp(int narg=0, char* arg[]=NULL);
     ~PITApp();
     virtual void   Process(PIMessage msg, PIMsgHandler* sender, void* data=NULL);

private :
  PILabel *lab;
  PIMenu * m[2];
  ArgsWind *mAW;
};


/* ........................................................... */
/*              Classe ArgsWindow (methodes)                   */
/* ........................................................... */

/* --Methode-- */
ArgsWind::ArgsWind(PIApplication *par)
: PIWindow((PIMsgHandler *)par, "Args", PIWK_dialog, 100, 100, 150, 150)
{
int bsx, bsy;
		printf("ArgsWind::ArgsWind\n");
	
// On definit la taille a partir de la taille par defaut des composantes 
PIApplicationPrefCompSize(bsx, bsy);
// On redefinit la taille de la fenetre
SetSize(bsx*4, bsy*4);
	printf("bsx:%d bsy:%d\n",bsx,bsy);
	
// Creation de champs "labels"
mLab[0] = new PILabel(this, "Arg-1:", bsx, bsy, bsx/3, bsy/4); 
mLab[1] = new PILabel(this, "Arg-2", bsx, bsy, bsx/3, bsy/4 + (bsy/4+bsy) );

// Creation de champs textes 
mText[0] = new PIText(this, "UsArg1", bsx*2, bsy, bsx+(bsx*2/3), bsy/4);
mText[0]->SetText("Hello ");
mText[1] = new PIText(this, "UsArg2", bsx*2, bsy, bsx+(bsx*2/3), 
                      bsy/4 + (bsy/4+bsy) );
mText[1]->SetText("1. -1.");

// Creation de bouton d'action 
//  Attention : Numero de message pour Process()
mBut[0] = new PIButton(this, "GetText",  555, bsx*1.5, bsy, bsx*0.25, 2.75*bsy);
mBut[1] = new PIButton(this, "Dismiss", 777, bsx*1.5, bsy, 2.25*bsx, 2.75*bsy);

//  Taille et position proportionnelles a la taille de la fenetre pour les elements
for(int i=0; i<2; i++) {
  mLab[i]->SetBinding(PIBK_elastic, PIBK_elastic, PIBK_elastic, PIBK_elastic);
  mText[i]->SetBinding(PIBK_elastic, PIBK_elastic, PIBK_elastic, PIBK_elastic);
  }
for(int ii=0; ii<2; ii++) 
  mBut[ii]->SetBinding(PIBK_elastic, PIBK_elastic, PIBK_elastic, PIBK_elastic);
}

/* --Methode-- */
ArgsWind::~ArgsWind()
{
for(int i=0; i<2; i++)
  {
  delete mLab[i];
  delete mText[i];
  }

delete mBut[0]; 
delete mBut[1]; 
}


/* --Methode-- */
void ArgsWind::Process(PIMessage msg, PIMsgHandler* /*sender*/, void* /*data*/)
{
	printf("ArgsWind::Process\n");

switch (UserMsg(msg))
  {
  case 777:   // Bouton dismiss - On s'en va 
    this->Hide();
    break;

  case 555:    // Bouton GetText
// On recupere les textes des  PIText :
    cout << "\n  ArgsWind::Process() " << endl; 
    cout << " Text-0 = " << mText[0]->GetText() << endl;
    cout << " Text-1 = " << mText[1]->GetText() << endl;
    break;    
  }
    
return;
}

/* ........................................................... */
/*               Classe PITApp (methodes)                      */
/* ........................................................... */

/* --Methode-- */
PITApp::PITApp(int narg, char* arg[])
: PIApplication(250, 60, narg, arg)
{

m[0] = new PIMenu(Menubar(),"Fichier");
m[0]->AppendItem("ShowArgs", 10101);
m[0]->AppendItem("HideArgs", 10102);
m[0]->AppendItem("Exit", 10105);
// On accroche le menu au Menubar
AppendMenu(m[0]);

m[1] = new PIMenu(Menubar(),"Edit");
m[1]->AppendItem("Cut", 10201);
m[1]->AppendItem("Copy", 10202);
m[1]->AppendItem("Paste", 10203);
// On accroche le menu au Menubar
AppendMenu(m[1]);

// Creation d' un label
lab = new PILabel(this->MainWin(), "xp1 - PI example program", 240, 40, 5, 10);
// Fenetre de dialogue
mAW = new ArgsWind(this);
SetReady();
}

/* --Methode-- */
PITApp::~PITApp()
{
delete m[0]; 
delete m[1]; 
delete lab;
delete mAW;
}  

/* --Methode-- */
void PITApp::Process(PIMessage msg, PIMsgHandler* sender, void* /*data*/)
{
// Gestion des actions en fonctions des messages

switch(UserMsg(msg))    {
    case 10101 :     // Apparition de la fenetre de dialogue
      mAW->Show();
      break;
    case 10102 :     // Apparition de la fenetre de dialogue
      mAW->Hide();
      break;
    case 10105:          // Sortie d'application
      Stop();
      break;

    default :
      cout << "PITApp::Process() Msg= " << msg << " UserMsg= " 
           << UserMsg(msg) << " ModMsg= " << ModMsg(msg) << endl;
     break;    
  }
return;
}
// ................................................................
//                   programme principal 
// ................................................................

int main(int narg, char *arg[])
{
if ( (narg > 1) && (strcmp(arg[1],"-h") == 0) ) {
  printf("xp0 : simple PI example program \n");
  printf("  Usage : xp0 [Xt options] \n");
  }
//  Creation de l'objet application et appel de Run()
PITApp * app = new PITApp(narg, arg);
puts("appel de Application.Run() ... ");
app->Run();

delete app;
exit(0);
}
