/*
    QuartzAppTest.cpp
    BMX 14/06/06
    Test Program for PI4Mac validation    
*/

#include <PIApplQuartz.h>
#include <PIMenuBarQuartz.h>
#include <PIWindowQuartz.h>
#include <pioptmenuquartz.h>
#include <pistdwdgquartz.h>
#include <pigraphquartz.h>
#include <pibwdgquartz.h>
#include <picons.h>
#include <iostream>

#define NBCOTE 7

/* ============================== */
class QuartzApp : public PIApplication
{
public:
	QuartzApp();
	~QuartzApp();
	virtual void Process (PIMessage msg, PIMsgHandler* sender, void * data = NULL);
};

/* ============================== */
class TstBWdg : public PIBaseWdg
{
public:
	TstBWdg(PIContainerGen *par, const char *nom, int sx, int sy, int px, int py);
	virtual void Draw(PIGraphic* g, int x0, int y0, int dx, int dy);
	void SetPolygon();
	void UnsetPolygon();
private:
	bool fgPolygon;
};

PIWindow* windowFirst;
TstBWdg* twdg;
/* ============================== */
QuartzApp::QuartzApp()
: PIApplication()
{
}

/* ============================== */
QuartzApp::~QuartzApp()
{
}

/* ============================== */

void QuartzApp::Process (PIMessage msg, PIMsgHandler* sender, void * data)
{
  std::cout << "QuartzApp::Process " ;
  
  switch(UserMsg(msg))    
	{	
		case 777:
		std::cout << " Pas Polygone " << std::endl;
		windowFirst->Refresh();
            if (twdg) {
                twdg->UnsetPolygon();

            }
            break;

		case 2001:
		std::cout << " Circle " << std::endl;
		// twdg->DrawCircle(360,100,30);
		break;
		
		case 2002:
		std::cout << " Polygone " << std::endl;
		twdg->SetPolygon();
		break;
		
		case 2003:
		std::cout << " Draw " << std::endl;
		twdg->Refresh();
		break;
		
		
		case 2004:
		std::cout << " Show " << std::endl;
		windowFirst->Refresh();
		break;
		
		case 3001:
		std::cout << " Pop 1 " << std::endl;
		break;
	
		case 3002:
		std::cout << " Pop 2 " << std::endl;
		break;
		
		default:
		std::cout << " msg : "<< UserMsg(msg) << std::endl;
		break;
	}

	return;
}

/* ============================================================================================================ */
/* ============================================================================================================ */
/* ============================================================================================================ */
/* ============================================================================================================ */
/* ============================================================================================================ */
/* ============================================================================================================ */
int main(int argc, char *argv[])
{
    QuartzApp* mainApp;
    PIMenu* firstMenu;
    PIMenu* underMenu;
	PIMenu* popMenu;
	PIMenu* figuresMenu;
	PIOptMenu* optMenu;  
    PIMenubar* mBar;
	PILabel *piLabel;
    PIButton* piButton;
    vector<int> points;

    printf("main debut\n");

    mainApp = new QuartzApp();

    /* Creation of Menu and Menu Items */
    firstMenu = new PIMenu((PIWdg *)mainApp, (const char *)"File Menu");
    firstMenu->AppendItem("One from file", 1000);
    firstMenu->AppendSeparator();
    firstMenu->AppendItem("Two from file", 1001);
    firstMenu->AppendCheckItem("Check from file", 1002);
    firstMenu->AppendItem("Quitter ", 1003);
    printf("main apres menu\n");
	
	underMenu = new PIMenu((PIWdg *)firstMenu,(const char *)"submenu");
    firstMenu->AppendCascadeMenu(underMenu, 1001);
	underMenu->AppendItem("Sub 1 from 2", 1010);
	underMenu->AppendItem("Sub 2 from 2", 1011);
    printf("main apres menu 2\n");

	figuresMenu = new PIMenu((PIWdg *)mainApp, (const char *)"Figures");
	figuresMenu->AppendItem("Circle", 2001);
	figuresMenu->AppendItem("Polygone", 2002);
	figuresMenu->AppendItem("Draw", 2003);
	figuresMenu->AppendItem("Show", 2004);
    mBar = mainApp->Menubar();
    mBar->AppendMenu(firstMenu);
    mBar->AppendMenu(figuresMenu);
    printf("main apres menu 3\n");
	
    /* Creation of Main Window */	
    windowFirst = new PIWindow((PIMsgHandler *)mainApp, (const char *)"Window First",PIWK_normal, 700, 700, 50, 50);
    printf("main apres creation window\n");

    /* Creation of general graphical objects */
//	piLabel = new PILabel(windowFirst,(const char *)"Label", 80, 40, 150, 50);

	piButton = new PIButton(windowFirst, "Hello------2", 777, 60, 20, 80, 80);
	
//	optMenu = new PIOptMenu(windowFirst, "Opt Menu", 100, 25, 150, 80);
//	popMenu = new PIMenu((PIWdg *)optMenu, (const char *)"Pop Menu",k_PopupMenu);
//	popMenu->AppendItem("pop 1", 3001);
//	popMenu->AppendItem("pop 2", 3002);
//	mBar->AppendPopupMenu(popMenu);
//	optMenu->AppendPDMenu(popMenu);
    printf("main apres ajout buttons\n");
	
//	piLabel->SetLabel("Etiquette-------2");
    printf("main apres ajoute etiquette\n");
	
    
    // PIConsole(PIContainer* par, const char* nom, PIMessage msg, \
    //           int nl, int nc, int sx, int sy, int px, int py, bool scb)
    //	Creation d'un objet PIConsole, avec "nl" lignes et  "nc" colonnes.
    //	"sx,sy" indique la taille de la fenetre. Si "scb==true", un
    //	ScrollBar est cree associe a l'objet PIConsole.
    //--
    
    PIConsole *console = new PIConsole(windowFirst, "console", 4000,
                                       3, 20, 200, 50, 300, 100, FALSE);
    console->SetPrompt("prompt");
    console->AddStr("mon texte");
    printf("main apres creation console\n");

	/* Creation of graphic Context */
	twdg = new TstBWdg(windowFirst, "Test BaseQuartz", 500, 500, 200, 200);
	windowFirst->Show();
	
    mainApp->Run(); // Main loop

    return 0;
}
/* ============================================================================================================ */
/* ============================================================================================================ */
/* ============================================================================================================ */
/* ============================================================================================================ */
/* ============================================================================================================ */
/* ============================================================================================================ */

/* ============================================================================================================ */
TstBWdg::TstBWdg(PIContainerGen *par, const char *nom, int sx, int sy, int px, int py)
: PIBaseWdg(par, nom, sx, sy, px, py)
{
	fgPolygon = false;
}

/* ============================================================================================================ */
void TstBWdg::Draw(PIGraphic* g, int x0, int y0, int dx, int dy)
{
	std::cout << "TstBWdg::Draw +++++++++";

	/*
	CGContextRef cg = ((PIGraphicWin*)g)->GetCGContext();
	printf(" cg : %lx ", (unsigned long)cg);
	CGAffineTransform cat = CGContextGetCTM (cg);
	*/
	
	CGAffineTransform cat = ((PIGraphicWin*)g)->GetCTM();
	std::cout << " CGAffineTransform : " << cat.a << " " << cat.b << " " << cat.c << " " ; 
	std::cout << cat.d << " t : " << cat.tx << " " << cat.ty << endl; 

	PIGrCoord px(20);
	PIGrCoord py(30);
	PIGrCoord len(150);
	PIGrCoord hei(50);
	g->SelForeground(PI_Blue);
	g->DrawFBox(px, py, len, hei);
	
	PIGrCoord px2(0);
	PIGrCoord py2(0);
	PIGrCoord len2(500);
	PIGrCoord hei2(500);
	g->SelForeground(PI_Red);
	g->DrawFBox(px2, py2, len2, hei2);
	
	px = 200 ; py = 50;
	g->DrawString (px, py, "Graphic Text", 1);

	px = 20 ; py = 150;
	PIGrCoord pxfin(200);
	PIGrCoord pyfin(230);
	g->SelForeground(PI_Brown);
	g->DrawLine (px, py, pxfin, pyfin);

	PIGrCoord deltax(60);
	PIGrCoord deltay(30);
	g->SelForeground(PI_Red);	
	g->DrawArc (px, py, deltax, deltay, 0., 90.);

	if (fgPolygon)
	{
		g->SelForeground(PI_Black);	

		PIGrCoord tabx[NBCOTE];
		PIGrCoord taby[NBCOTE];
		std::cout << " Draw Polygon " << std::endl;
		tabx[0] = 80 ;	tabx[1] = 100; tabx[2] = 120;	tabx[3] = 140;	tabx[4] = 130;	tabx[5] = 110; tabx[6] = 90;
		taby[0] = 50;	taby[1] = 60; taby[2] = 70;	taby[3] = 80;	taby[4] = 60;	taby[5] = 40; taby[6] = 20;

		g->DrawPolygon(tabx, taby, NBCOTE, 0);
	}
	return;
}

/* ============================================================================================================ */
void TstBWdg::SetPolygon()
{
	fgPolygon = true;
	Refresh();
}

/* ============================================================================================================ */
void TstBWdg::UnsetPolygon()
{
	fgPolygon = false;
	Refresh();
}

