#include <stdio.h>

#include "sopnamsp.h"
#include "piwdgquartz.h"
#include "picmapquartz.h"

/* --Methode-- */
PIColorMapQuartz::PIColorMapQuartz()    
: PIColorMapGen()
{
mColors = NULL;
mColRGB = NULL;
mNewCol = NULL;
}

/* --Methode-- */
PIColorMapQuartz::PIColorMapQuartz(int id, int nc, string const& nom)    
: PIColorMapGen(id, nc, nom)
{

int n = nc;
mColors = new PIQuartzColor[n];
mColRGB = new PIColor[n];
mNewCol = new bool[n];
/*
for(int i=0; i<n; i++)
  { mColors[i] = BlackPixel(PIXDisplay(), PIXScreen());
  mColRGB[i].red = mColRGB[i].green = mColRGB[i].blue = 0; 
  mNewCol[i] = false; }
// printf("PIColorMapQuartz::PIColorMapQuartz(CMapId, int) %d %d \n", mNCol, Type());
*/
}


/* --Methode-- */
PIColorMapQuartz::~PIColorMapQuartz()
{
if (mColors)  delete[] mColors;
if (mColRGB)  delete[] mColRGB;
if (mNewCol)  delete[] mNewCol;
}


/* --Methode-- */
PIColor PIColorMapQuartz::GetColor(int n)
{
if ((n<0) || (n >= NCol()))   
  {
  PIColor picr;
  picr.red = picr.green = picr.blue = 0;
  return(picr);
  }
if (mFlagReversedIndex) return(mColRGB[NCol()-n-1]);
else return(mColRGB[n]);
}

//static  Colormap  defxcmap;
//static  int xinicmap = 0;
static int NTotColors = 0;
static int NTotAllocCol = 0;

//static int nerrallocol = 0;

/* --Methode-- */
bool PIColorMapQuartz::AllocColor(PIColor const& col, int index)
{
/*
XColor myxcol;

if (!xinicmap)  
  {
  defxcmap = XDefaultColormap (PIXDisplay(), PIXScreen());
  xinicmap = 1;
  }

if ( (index < 0) || (index >= mNCol) )  return(false);

if ( (col.red == 0) && (col.green == 0) && (col.blue == 0) )
  {
  mColors[index] = BlackPixel(PIXDisplay(), PIXScreen());
  mColRGB[index] = col; 
  mNewCol[index] = false;
  return(true);
  }

// Pour diminuer les requetes X, on verifie si la couleur 
// ne se trouve pas deja dans la table    Reza 19/05/98
int kc;
for(kc=0; kc<mNCol; kc++) 
  if ( (col.red == mColRGB[kc].red) && (col.green == mColRGB[kc].green) &&   (col.blue == mColRGB[kc].blue) )
    { mColors[index] = mColors[kc];  mColRGB[index] = mColRGB[kc]; 
    mNewCol[index] = false;  return(true); }

 
myxcol.red = col.red; 
myxcol.blue = col.blue;
myxcol.green = col.green;


if ( XAllocColor(PIXDisplay(), defxcmap, &myxcol) ) {
  mColors[index] = myxcol.pixel;
  mColRGB[index] = col; 
  mNewCol[index] = true;
//  printf("PIColorMapQuartz::AllocColor()  RGB= %d %d %d \n",
//         (int) col.red, (int) col.blue, (int) col.green);
  NTotAllocCol++;  
  return(true);
  }
else {
  nerrallocol++;
  if (nerrallocol < 21) printf("PIColorMapQuartz::AllocColor() Error: Pb Allocation RGB= %d %d %d \n",
         (int) col.red, (int) col.blue, (int) col.green);
  if (nerrallocol == 20) printf("No more  PIColorMapQuartz::AllocColor() Errors will be reported \n");
  return(false);
  }
  */
  return true;
}

/* --Methode-- 
void PIColorMapQuartz::MakeColMap()
{
}
*/

/* --Methode-- */
void PIColorMapQuartz::FreeColors()
{
/*
PIQuartzColor bpix;
PIColor blc;

if (!xinicmap)  
  {
  defxcmap = XDefaultColormap (PIXDisplay(), PIXScreen());
  xinicmap = 1;
  }

for (int i=0; i<mNCol; i++)
  if ( mNewCol[i] )    XFreeColors(PIXDisplay(), defxcmap, mColors+i, 1, 0);

bpix = BlackPixel(PIXDisplay(), PIXScreen());
blc.red = blc.green = blc.blue = 0;
{for (int i=0; i<mNCol; i++)  
  { mColors[i] = bpix;   mColRGB[i] = blc;  mNewCol[i] = false; }
}
// printf("PIColorMapQuartz::FreeColors()  Type= %d mNCol= %d \n",
//        Type(), NCol());
*/
return;
}


/* --Methode-- */
long PIColorMapQuartz::TotNbColors()
{
NTotColors = 256;

if (NTotColors > 0)  return(NTotColors);
// Visual* vis;
// DefaultVisual(PIXDisplay(),  PIXScreen() );
/*
int k,kk;
// On calcule le nombre de couleurs a partir du nb de plans image
kk = DefaultDepth(PIXDisplay(),  PIXScreen() );
NTotColors = 1;
for(k=0; k<kk; k++) NTotColors *= 2;

 printf("PIColorMapQuartz::TotNbColor() / Debug : Nb Tot Colors = %d - D=%d - NCol=%d NP= %d \n", NTotColors, 
 DefaultDepth(PIXDisplay(),  PIXScreen()), 
 DisplayCells(PIXDisplay(),  PIXScreen()), 
 DisplayPlanes(PIXDisplay(),  PIXScreen()) );
*/
return(NTotColors);
}

/* --Methode-- */
int PIColorMapQuartz::NbAllocColors()
{
return(NTotAllocCol);
}


/* --Methode-- */
void PIColorMapQuartz::CopyFrom(PIColorMapGen* x)
{
  if (mColors)  delete mColors;
  if (mColRGB)  delete mColRGB;
  if (mNewCol)  delete mNewCol;
  CopyFromGen(x);
  mColors = new PIQuartzColor[mNCol];
  mColRGB = new PIColor[mNCol];
  mNewCol = new bool[mNCol];
  for (int i=0; i<mNCol; i++)  
    { mColors[i] = ((PIColorMapQuartz *)x)->mColors[i];
    mColRGB[i] = ((PIColorMapQuartz *)x)->mColRGB[i]; 
// C'est la table de couleur originale qui est responsable de liberer les couleurs - Reza 8/2/98
    mNewCol[i] = false; }  
}
