/*
 *  pistdwdgmosx.cpp
 *  PI
 *
 *  Created by Bruno MANSOUX on 24/08/07.
 *  Copyright 2007 __MyCompanyName__. All rights reserved.
 *
 */

#include "pistdwdgquartz.h"

vector<PIWdg*> vpiwdg;

static void CommonControlActionCallback (ControlRef theControl, ControlPartCode partCode);

static void CommonControlActionCallback (ControlRef theControl, ControlPartCode partCode)
{
	vector<PIWdg*>::iterator it;
	for(it = vpiwdg.begin(); it != vpiwdg.end(); it++)
        {
			printf ("click : %d \n",(int)(*it)->Msg());
            if (((*it)->GetHIViewRef()) == theControl)
            {
				printf ("Valid : %d \n",(int)(*it)->Msg());
				(*it)->Send((*it)->Msg(), PIMsg_Click, NULL);
                break;
            }
        }
	return;
}

/* ========== PILabelQuartz ========== */

/* --Methode-- */
PILabelQuartz::PILabelQuartz(PIContainerGen *par, const char *nom, int sx, int sy, int px, int py)
: PILabelGen(par, nom, sx, sy, px, py)
{
	OSStatus err;
	WindowRef wParent;
	
	string sNom(nom);
	wParent = ((PIContainer *)par)->GetWindowRef();
	SetPortWindowPort(wParent);
    SetRect(&wdgRect,px,py,px+sx,py+sy);
	cfsrLabel = CFStringCreateWithCString(kCFAllocatorDefault,nom,kCFStringEncodingMacRoman);
	err = CreateStaticTextControl (wParent, &wdgRect, cfsrLabel, NULL, &wdgHIView);
}

/* --Methode-- */
PILabelQuartz::~PILabelQuartz()
{
}

/* --Methode-- */
void PILabelQuartz::SetLabel(string const& sLabel)
{
	OSStatus err;
	
	cfsrLabel = CFStringCreateWithCString(kCFAllocatorDefault,sLabel.c_str(),kCFStringEncodingMacRoman);
	// SetPortWindowPort(wParent);

	err = SetControlData (wdgHIView,0,kControlEditTextCFStringTag,sizeof(cfsrLabel),(Ptr)&cfsrLabel);

	return;
}


/* ========== PITextQuartz ========== */

/* --Methode-- */
PITextQuartz::PITextQuartz(PIContainerGen *par, const char *nom, int sx, int sy, int px, int py)
: PITextGen(par, nom, sx, sy, px, py)
{
    SetRect(&wdgRect,px,py,px+sx,py+sy);
}

/* --Methode-- */
PITextQuartz::PITextQuartz(PIContainerGen* par, const char* nom, bool vsb, bool hsb,
         		     int sx, int sy, int px, int py)
: PITextGen(par, nom, vsb, hsb, sx, sy, px, py)
{
}

/* --Methode-- */
PITextQuartz::~PITextQuartz()
{
}

/* --Methode-- */
void PITextQuartz::SetText(string const& s)
{	
	OSStatus err;
	WindowRef wParent = ((PIContainer *)Parent())->GetWindowRef();

	unicodeText = CFStringCreateWithCString (NULL,(char *)s.c_str(), kCFStringEncodingMacRoman);
	err = CreateEditUnicodeTextControl (wParent,&wdgRect,unicodeText,false,NULL,&wdgHIView);

	return;
}

/* --Methode-- */
string PITextQuartz::GetText() const
{
	CFStringRef str;
	char* cText;

	GetControlData(wdgHIView, kControlEditTextPart, kControlEditTextCFStringTag, sizeof(str),&str,NULL);
	
	cText = (char *)CFStringGetCStringPtr(str,kCFStringEncodingMacRoman);	
	string sText(cText);	
	return (sText);
}

/* --Methode-- */
void PITextQuartz::SetMutiLineMode(bool mlm)
{
	return;
}


/* --Methode-- */
void PITextQuartz::SetTextEditable(bool te)
{
	if (te == false)
		DeactivateControl (wdgHIView);

	return;
}

/* --Methode-- */
void PITextQuartz::SetMsg(PIMessage msg)
{
}


/* ========== PIHITextViewQuartz ========== */

/* --Methode-- */
PIHITextViewQuartz::PIHITextViewQuartz(PIContainerGen *par, const char *nom, int sx, int sy, int px, int py)
: PITextGen(par, nom, sx, sy, px, py)
{
	OSStatus err;
	HIRect	hiRect; // = { { 0, 0 }, { 100, 100 } };
	int ox,oy,fx,fy;
	int mx,my;
	WindowRef wParent = ((PIContainer *)par)->GetWindowRef();
	mx = sx/50;
	my = sy/50; 
	ox = px+mx;
	oy = py+my;
	fx = px+sx-mx;
	fy = py+sy-my;
    SetRect(&wdgRect,px,py,px+sx,py+sy);

	SetRect(&userPaneRect,ox,oy,fx,fy);
	hiRect.origin.x = ox;
	hiRect.origin.y = oy;
	hiRect.size.width = fx-ox;
	hiRect.size.height = fy-oy;
	err = HITextViewCreate (&hiRect,0,0,&outTextView);
	err = CreateUserPaneControl (wParent, &userPaneRect,kControlSupportsEmbedding,&fUserPane);
	err = SetControlVisibility(fUserPane, true, true );
}

/* --Methode-- */
PIHITextViewQuartz::PIHITextViewQuartz(PIContainerGen* par, const char* nom, bool vsb, bool hsb,
         		     int sx, int sy, int px, int py)
: PITextGen(par, nom, vsb, hsb, sx, sy, px, py)
{
}

/* --Methode-- */
PIHITextViewQuartz::~PIHITextViewQuartz()
{
}


/* --Methode-- */
void PIHITextViewQuartz::SetText(string const& s)
{	
	OSStatus err;
	CFStringRef cfsrText;
	
	cfsrText = CFStringCreateWithCString (NULL,(char *)s.c_str(), kCFStringEncodingMacRoman);

	TXNObject txn = HITextViewGetTXNObject(outTextView);
	textLength = CFStringGetLength(cfsrText);
	uniChars = (UniChar*) malloc( sizeof( UniChar ) * textLength );
	CFStringGetCharacters(cfsrText, CFRangeMake( 0, textLength ), uniChars );
	err = TXNSetData(txn,kTXNUnicodeTextData, uniChars, textLength * sizeof( UniChar ), 0, 0 );
	err = HIViewAddSubview (fUserPane, outTextView);
	HIViewPlaceInSuperviewAt (outTextView,10,10);
	ShowControl (fUserPane);
	err = HIViewSetVisible (outTextView, true);

	return;
}

/* --Methode-- */
string PIHITextViewQuartz::GetText() const
{
	CFStringRef str;
	char* cText;

	GetControlData(outTextView, kControlEditTextPart, kControlEditTextCFStringTag, sizeof(str),&str,NULL);
	cText = (char *)CFStringGetCStringPtr(str,kCFStringEncodingMacRoman);
	/*
	textLength = CFStringGetLength(str);
	uniChars = (UniChar*) realloc( sizeof( UniChar ) * textLength );
	CFStringGetCharacters(str, CFRangeMake( 0, textLength ), uniChars );
	*/
	
	string sText(cText);	
	return (sText);
}


/* --Methode-- */
void PIHITextViewQuartz::SetMutiLineMode(bool mlm)
{
	return;
}


/* --Methode-- */
void PIHITextViewQuartz::SetTextEditable(bool te)
{
	return;
}


/* --Methode-- */
void PIHITextViewQuartz::SetMsg(PIMessage msg)
{

}

/* ========== PIButtonQuartz ========== */

EventTypeSpec controlEvents[] = {{kEventClassControl, kEventControlHit}};

PIButtonQuartz::PIButtonQuartz(PIContainerQuartz *par,const char *nom, PIMessage msg,int sx, int sy, int px, int py)
:PIButtonGen(par,nom,msg,sx,sy,px,py)
{
	WindowRef wParent = ((PIContainer *)par)->GetWindowRef();
	SetPortWindowPort(wParent);
    SetRect(&wdgRect,px,py,px+sx,py+sy);

    CreatePushButtonControl (par->GetWindowRef(),&wdgRect,title,&wdgHIView);
    SetControlTitleWithCFString (wdgHIView, title);
	_actionProc = NewControlActionUPP (CommonControlActionCallback);
	SetControlAction (wdgHIView, _actionProc);
	vpiwdg.push_back(this);
}


PIButtonQuartz::~PIButtonQuartz()
{
}

void PIButtonQuartz::ActivatePress(bool acp)
{
	return;
}	

void PIButtonQuartz::SetLabel(string const& sText)
{
    title = CFStringCreateWithCString (NULL, sText.c_str(), kCFStringEncodingMacRoman);
	SetControlTitleWithCFString(wdgHIView,title);
	return;
}



/* ========== PICheckBoxQuartz ========== */

PICheckBoxQuartz::PICheckBoxQuartz(PIContainerQuartz *par, const char *nom, PIMessage msg, int sx, int sy, int px, int py)
:PICheckBoxGen(par,nom,msg,sx,sy,px,py)
{
	WindowRef wParent = ((PIContainer *)par)->GetWindowRef();
	SetPortWindowPort(wParent);
    SetRect(&wdgRect,px,py,px+sx,py+sy);
    CreateCheckBoxControl (par->GetWindowRef(),&wdgRect,title,0,TRUE,&wdgHIView);
    SetControlTitleWithCFString (wdgHIView, title);
	_actionProc = NewControlActionUPP (CommonControlActionCallback);
	SetControlAction (wdgHIView, _actionProc);
	_state = GetControl32BitValue (wdgHIView);

	vpiwdg.push_back(this);
}


PICheckBoxQuartz::~PICheckBoxQuartz()
{
}

void PICheckBoxQuartz::SetState(bool acp)
{
	_state = acp;
	return;
}

bool PICheckBoxQuartz::GetState()
{
	_state = GetControl32BitValue (wdgHIView);
	printf("GetState : %d ",_state);
	return _state;
}

/* ========== PIRadioQuartz ========== */

PIRadioQuartz::PIRadioQuartz(PIContainerQuartz *par,const char *nom, PIMessage msg,int sx, int sy, int px, int py,
							int initialValue)
:PIWdg(par,nom,sx,sy,px,py)
{
	SetMsg(msg);
	WindowRef wParent = ((PIContainer *)par)->GetWindowRef();
	SetPortWindowPort(wParent);
    SetRect(&wdgRect,px,py,px+sx,py+sy);
    CreateRadioButtonControl (par->GetWindowRef(),&wdgRect,title,initialValue,FALSE,&wdgHIView);
    SetControlTitleWithCFString (wdgHIView, title);
	_actionProc = NewControlActionUPP (CommonControlActionCallback);
	SetControlAction (wdgHIView, _actionProc);
	vpiwdg.push_back(this);
}

PIRadioQuartz::~PIRadioQuartz()
{
}

/* ========== PIRadioGroupQuartz ========== */

PIRadioGroupQuartz::PIRadioGroupQuartz(PIContainerQuartz *par,const char *nom, PIMessage msg,int sx, int sy, int px, int py)
:PIWdg(par,nom,sx,sy,px,py)
{
	SetMsg(msg);
	WindowRef wParent = ((PIContainer *)par)->GetWindowRef();
	SetPortWindowPort(wParent);
    SetRect(&wdgRect,px,py,px+sx,py+sy);
    OSErr error;
	error = CreateRadioGroupControl (par->GetWindowRef(),&wdgRect,&wdgHIView);
	_state = 0;
}

void PIRadioGroupQuartz::AddRadioButton(PIRadio* piRadio)
{
	OSErr error;
	error = EmbedControl(piRadio->GetHIViewRef(),wdgHIView);
		
	return;
}

PIRadioGroupQuartz::~PIRadioGroupQuartz()
{
}


PIScrollBarQuartz::PIScrollBarQuartz(PIContainerQuartz *par, const char *nom, PIMessage msg, 
									 int dir, int sx, int sy, int px, int py)
: PIScrollBarGen(par, nom, msg, dir, sx, sy, px, py){
	printf("PIScrollBarQuartz:PIScrollBarQuartz:   NOT IMPLEMENTED\n");
}

void PIScrollBarQuartz::GetMinMax(int& min, int& max){
	printf("PIScrollBarQuartz::GetMinMax   NOT IMPLEMENTED\n");
}


int PIScrollBarQuartz::GetValue(){
	printf("PIScrollBarQuartz::GetValue   NOT IMPLEMENTED\n");
	return 0;
}


int PIScrollBarQuartz::GetSlSize(){
	printf("PIScrollBarQuartz::GetSlSize   NOT IMPLEMENTED\n");
	return 0;
}


void PIScrollBarQuartz::SetMinMax(int, int){
	printf("PIScrollBarQuartz::SetMinMax   NOT IMPLEMENTED\n");
}


void PIScrollBarQuartz::SetSlSize(int){
	printf("PIScrollBarQuartz::SetSlSize   NOT IMPLEMENTED\n");
}


void PIScrollBarQuartz::ActivateDrag(bool){
	printf("PIScrollBarQuartz::ActivateDrag   NOT IMPLEMENTED\n");
}


void PIScrollBarQuartz::SetValue(int){
	printf("PIScrollBarQuartz::SetValue   NOT IMPLEMENTED\n");
}

// Global function SetRect
void SetRect(Rect* wdgRect,short px,short py,short sright,short sbottom){
    wdgRect->left = px;
    wdgRect->right= sright;
    wdgRect->top = py;
    wdgRect->bottom = sbottom;
}

