#include<stdio.h>

#include "pilistx.h"
#include "picontainerx.h"

#include <Xm/Xm.h>
#include <Xm/List.h>


/************* PIListX ************/

// Pour ces sal... de XmString  (ds piwdgx.cc)
int CStrFrXmStr(XmString xms, char* buff, int nmx);

// Fonction prive (CallBack)
static void list_action(Widget w, XtPointer *usd, XmListCallbackStruct *isel);

/* Nouvelle-Fonction */
void  list_action(Widget /*w*/, XtPointer *usd, XmListCallbackStruct *isel)
{
PIListX *pil;

pil = (PIListX *)usd ;
pil->ToggleSel(isel->item_position, true);
//printf("list_action/Debug: reason=%d itemPos= %d \n", 
//isel->reason, isel->item_position);
return;
}


#define NBITEMB  20
#define NBISELB  5


/* --Methode-- */
PIListX::PIListX(PIContainerGen* par, char* nom,
                 int sx, int sy, int px, int py)
: PIListGen(par, nom, sx, sy, px, py)
{

mNItem = mNItemMax = 0;
mMess = NULL;  mSel = NULL;
mNbSel = mNSelMax = 0;
mSelNum = NULL;
 
Arg  warg[3];
int n = 0;
XtSetArg(warg[n], XmNlistSizePolicy, XmCONSTANT);  n++;
XtSetArg(warg[n], XmNscrollBarDisplayPolicy, XmAS_NEEDED);  n++;
mlist = XmCreateScrolledList(((PIWdgX *)par)->XtWdg(), nom, warg, n);
XtManageChild(mlist);
XtWdg() = XtParent(mlist);
SetSize(sx, sy);
SetPos(px, py);
wmis == k_wmi_normal ;
stmng = 0;

//XtAddCallback(mlist, XmNdefaultActionCallback,
//              list_action, (XtPointer)this);
XtAddCallback(mlist, XmNmultipleSelectionCallback,
              (XtCallbackProc)list_action, (XtPointer)this);
XtAddCallback(mlist, XmNsingleSelectionCallback,
              (XtCallbackProc)list_action, (XtPointer)this);

SetMultipleSelect(false);
Manage();
}

/* --Methode-- */
PIListX::~PIListX()
{

if (mNItemMax > 0)  
  {
    //  XtFree((char *)mItems);
  delete[] mMess;
  delete[] mSel;
  }  
if (mNSelMax > 0)  delete[] mSelNum;
}


/* --Methode-- */
void PIListX::AppendItem(char* item, PIMessage msg)
{

if (mNItem >= mNItemMax)
  {
  PIMessage *mso;
  bool *slo;
  int i;

  mso = mMess;
  slo = mSel;
  mNItemMax += NBITEMB;
  mMess = new PIMessage[mNItemMax];
  mSel = new bool[mNItemMax];
  for(i=0; i<mNItem; i++)   
    {  mMess[i] = mso[i];  mSel[i] = slo[i]; }

  delete[] mso;
  delete[] slo;
  }

mMess[mNItem] = msg;
mSel[mNItem] = false;
mNItem++;

XmString xms = XmStringCreate(item, XmSTRING_DEFAULT_CHARSET);
XmListAddItem(mlist, xms, 0);
XmStringFree(xms);
return;
}

/* --Methode-- */
void PIListX::DeleteItem(char *item)
{
int n;
if ((n=GetNumItem(item)) < 0)  return;
DelItem(n);
return;
}

/* --Methode-- */
void PIListX::DeleteItem(PIMessage msg)
{
int n;
if ((n=GetNumItemMsg(msg)) < 0)  return;
DelItem(n);
return;
}


/* --Methode-- */
void PIListX::SetMultipleSelect(bool ms)
{
Arg  warg[2];

mMultSel = ms;
if (ms)
  XtSetArg(warg[0], XmNselectionPolicy, XmMULTIPLE_SELECT);  
else
  XtSetArg(warg[0], XmNselectionPolicy, XmSINGLE_SELECT);  

XtSetValues(mlist, warg, 1);
}

/* --Methode-- */
int PIListX::GetNbSelection()
{
return(mNbSel);
}

/* --Methode-- */
PIMessage PIListX::GetSelection(int num)
{
return(ItemMsg(mSelNum[num]));
}

/* --Methode-- */
string PIListX::GetSelectionStr(int num)
{
string s(ItemStr(mSelNum[num]));
return(s);
}

/* --Methode-- */
void PIListX::SelectItem(char * item)
{
int n;
if ((n=GetNumItem(item)) < 0)  return;
if ((!mMultSel) && (mNbSel > 0) && (mSelNum[0] != n))
  ClrSItem(mSelNum[0], false, true);  
SelItem(n, false, true);
return;
}

/* --Methode-- */
void PIListX::SelectItem(PIMessage msg)
{
int n;
if ((n=GetNumItemMsg(msg)) < 0)  return;
if ((!mMultSel) && (mNbSel > 0) && (mSelNum[0] != n))
  ClrSItem(mSelNum[0], false, true);  
SelItem(n, false, true);
return;
}


/* --Methode-- */
void PIListX::ClearSelItem(char * item)
{
int n;
if ((n=GetNumItem(item)) < 0)  return;
ClrSItem(n, false, true);
return;
}

/* --Methode-- */
void PIListX::ClearSelItem(PIMessage msg)
{
int n;
if ((n=GetNumItemMsg(msg)) < 0)  return;
ClrSItem(n, false, true);
return;
}


/* --Methode-- */
void PIListX::ToggleSel(int n, bool smg)
{
if ( (n < 0) || (n >= mNItem))  return;
if (mSel[n])  ClrSItem(n,smg); 
else
  {
  if ((!mMultSel) && (mNbSel > 0))  ClrSItem(mSelNum[0], smg);
  SelItem(n, smg);
  }
}


/* --Methode-- */
PIMessage PIListX::ItemMsg(int n)
{
if ( (n < 0) || (n >= mNItem))  return(0);
else return(mMess[n]);
}

/* --Methode-- */
char * PIListX::ItemStr(int n)
{
Arg  warg[2];
XmString *xmst;

if ( (n < 0) || (n >= mNItem))  { mSItem[0] = '\0'; return(mSItem); }

XtSetArg(warg[0], XmNitems, &xmst);  
XtGetValues(mlist, warg, 1);
CStrFrXmStr(xmst[n], mSItem, 320);
return(mSItem);
}

/* --Methode-- */
int PIListX::GetNumItem(char *it)
{
for(int i=0; i<mNItem; i++)
  if (strcmp(ItemStr(i), it) == 0)  return(i);
return(-1);
}

/* --Methode-- */
int PIListX::GetNumItemMsg(PIMessage msg)
{
for(int i=0; i<mNItem; i++)
  if (mMess[i] == msg)   return(i);  
return(-1);
}



/* --Methode-- */
void PIListX::DelItem(int n)
{
int i;

if ((n < 0) || (n > mNItem))  return;

ClrSItem(n);
for(i=n; i<mNItem-1; i++)
  { mMess[i] = mMess[i+1];  mSel[i] = mSel[i+1]; }
mNItem--;

if (mNItem < (mNItemMax-NBITEMB-1))
  {
    //  XmString *ito;
  PIMessage *mso;
  bool *slo;

  //  ito = mItems;
  mso = mMess;
  slo = mSel;
  mNItemMax -= NBITEMB;
  mMess = new PIMessage[mNItemMax];
  mSel = new bool[mNItemMax];
  //  mItems = (XmString *) XtMalloc(sizeof(XmString)*mNItemMax);
  for(i=0; i<mNItem; i++)   
    { // mItems[i] = ito[i];
    mMess[i] = mso[i];  mSel[i] = slo[i]; }

  //  XtFree((char *)mItems);
  delete[] mso;
  delete[] slo;
  }

XmListDeletePos(mlist, n+1);
return;
}


/* --Methode-- */
bool PIListX::SelItem(int n, bool smg, bool cxw)
{
int i;

if ((n < 0) || (n > mNItem))  return(false);
if (mSel[n])  return(false);

mSel[n] = true;
if (mNbSel >= mNSelMax)
  {
  int * osel;
  osel = mSelNum;
  mNSelMax += NBISELB;
  mSelNum = new int[mNSelMax];
  for(i=0; i<mNbSel; i++)  mSelNum[i] = osel[i];
  if (osel)  delete[] osel;
  }

mSelNum[mNbSel] = n; 
mNbSel++;
if (smg)  
  Send(mMess[n], PIMsg_Select); 
if (cxw)
  XmListSelectPos(mlist, n+1, FALSE);
return(true);
}




/* --Methode-- */
bool PIListX::ClrSItem(int n, bool smg, bool cxw)
{
int i;
if ((n < 0) || (n > mNItem))  return(false);
if (!mSel[n])  return(false);
mSel[n] = false;

mNbSel --;
if (smg)  
  Send(mMess[n], PIMsg_ClearSel); 
if (cxw)
  XmListDeselectPos(mlist, n+1);

delete[] mSelNum;
if (mNbSel <= 0)
  { mNSelMax = mNbSel = 0;  mSelNum = NULL; }
else
  {
  mNSelMax = (mNbSel+NBISELB)/NBISELB;
  mSelNum = new int[mNSelMax];
  mNbSel =  0;
  for(i=0; i<mNItem; i++)
    if (mSel[i]) { mSelNum[mNbSel] = i; mNbSel++; }
  }

return(true);
} 


/* --Methode-- 
    A Supprimer .....
void PIListX::ChangeSel()
{
XmString *xmst;
int n;

n=0;
XtSetArg(warg[n], XmNselectedItems, &xmst);  n++;
XtGetValues(mlist, warg, n);
if (xmst)  XtFree(xmst);
xmst =  (XmString *) XtMalloc(sizeof(XmString)*mNbSel);
for(i=0; i<mNbSel; i++)
  xmst[i] = mItems[mSelNum[i]];
n=0;
XtSetArg(warg[n], XmNselectedItems, xmst);  n++;
XtSetArg(warg[n], XmNselectedItemCount, mNbSel);  n++;
XtSetValues(mlist, warg, n);
return;
}
   .....  */
