#include "templocator.h"
#include <math.h>
extern "C" {
#include "aa_hadec.h"
}

#ifndef M_PI
#define M_PI 3.14159265358979323846
#endif

TempLocator tempLocator;

TempLocator::TempLocator()
{
  lon = lat = ts = 0;
}

void TempLocator::setEarthPos(double lon, double lat) {
  this->lon = lon;
  this->lat = lat;
}
void TempLocator::setTSid(double ts) {
  this->ts  = ts;
}
  
double TempLocator::getAlphaZenith() {
  double ha, dec;
  aa_hadec (lat * M_PI/180, .5 * M_PI, 0, &ha, &dec);
  double ra = - (ha * 180. / M_PI / 15) + (ts/3600.);
  //dec = dec * 180. / M_PI;
  return ra;
}

double TempLocator::getDeltaZenith() {
  double ha, dec;
  aa_hadec (lat * M_PI/180, .5 * M_PI, 0, &ha, &dec);
  //double ra = - (ha * 180. / M_PI / 15) + (ts/3600.);
  dec = dec * 180. / M_PI;
  return dec;
}


