#include "templocator.h"
#include <math.h>
extern "C" {
#include "aa_hadec.h"
}

#include "fitsio.h"
#include "plgalcross.h"

#ifndef M_PI
#define M_PI 3.14159265358979323846
#endif

TempLocator tempLocator;

TempLocator::TempLocator()
{
  lon = lat = ts = 0;
  ra  = dec = -99999;
  xSampleNum = -99999;
  fitsfile* fptr;
  int status=0;
  fits_open_file(&fptr, "samplenum_gal_cross.fits", READONLY, &status);
  int simple, bitpix, naxis;
  long naxes;
  long pcount, gcount;
  int extend;
  fits_read_imghdr(fptr, 1, &simple, &bitpix, &naxis, &naxes, &pcount, &gcount, &extend, &status);
  nGalCross = naxes;
  crossings = new long[nGalCross];
  int anynul;
  fits_read_img_lng(fptr, 0, 1, nGalCross, 0, crossings, &anynul, &status);
  fits_close_file(fptr, &status);
  fits_report_error(stderr, status);  /* print out any error messages */
}
           
           
void TempLocator::setEarthPos(double lon, double lat) {
  if (this->lon == lon && this->lat == lat) return;
  this->lon = lon;
  this->lat = lat;
  ra  = dec = -99999; xSampleNum = -99999;
}

void TempLocator::setTSid(double ts) {
  if (this->ts == ts) return;
  this->ts  = ts;
  ra  = dec = -99999; xSampleNum = -99999;
}
  
void   TempLocator::ComputeZenith() {
  double ha;
  aa_hadec (lat * M_PI/180, .5 * M_PI, 0, &ha, &dec);
  ra = - (ha * 180. / M_PI / 15) + (ts/3600.);
  dec = dec * 180. / M_PI;
}
  
double TempLocator::getAlphaZenith() {
  if (ra < -100) ComputeZenith();
  return ra;
}

double TempLocator::getDeltaZenith() {
  if (dec < -100) ComputeZenith();
  return dec;
}

void TempLocator::findGeomFromGC(int sampleNum) // pour le bolo qui voit les xing
{
  if (sampleNum == xSampleNum) return;
  if (dec < -100) ComputeZenith();
  
  azimBolGC = -9999;
  
  // On trouve les croisements juste avant et juste apres notre sampleNum
  int icross;
  for (icross=0; icross<nGalCross; icross++) {
    if (crossings[icross] > sampleNum) break;
  }
  if (icross == 0 || icross >= nGalCross) return;
  
  // On trouve l'azimut du croisement principal pour notre position actuelle
  double alpG = 12. + 51./60. + 30./3600.;
  double delG = 27. + 07./60. + 42./3600.;
  double azCr1, azCr2;
  int rc = PlGalCross(ts/3600., lat, (90. - 41.), alpG, delG, azCr1, azCr2);
  
}


 			//	 ;
  			//	 ;                            /\         4     2
  			//	 ;                  elevation ||                       positive scanning, clockwise
  			//	 ;                            ||       6    1    5      ---------->
  			//	 ;                            ||                      == positive azimut
  			//	 ;                            ||         x     3
            //                                         |----|      = 0.78 deg / cos(elev)
            // bol 1 = 41 elevation
            