// toisvr.h
// Eric Aubourg         CEA/DAPNIA/SPP   juillet 1999


#ifndef TOISVR_H
#define TOISVR_H

#include "toiiter.h"
#include <list>

class AuxGPS;

class RequestHandler {
public:
  virtual bool processTOIReq(string line, string toiname, TOIKind toi, int index, 
                             bool interp, bool repet, bool flag, bool notrig)=0;
  virtual bool processOption(string keyw, string args)=0;
};

class TOISvr : public RequestHandler {
public:
  TOISvr();
  
  void setDirectory(string);
  void addFile(string);
  void onBoardRecorderFiles(bool);
  void useAuxGPS(AuxGPS* gps);
  
  void setTimeInterval(double tStart, double tEnd);
  void setUnderSample(int n);
  
  void addInfo(TOIKind kind, int index, bool triggering=true, bool interp=false);
  void addInfo(TOIKind kind, bool triggering=true, bool interp=false);
  
  void readReq(istream& s);
  
  TOIIter doQuery();

  bool processRequest(string line);
  void registerReqHandler(RequestHandler*);
  virtual bool processTOIReq(string line, string toiname, TOIKind toi, int index, 
                             bool interp, bool repet, bool flag, bool notrig);
  virtual bool processOption(string keyw, string args);
  
  void defaultInclude();
  
protected:
  TOIIter iter;
  list<RequestHandler*> handlers;
  
  bool initDone;
};


#endif
