//for archediab
//#include "manip.h"
//for archTOI
#include <stdio.h>
#include "archeops.h"
#include "arcunit.h"

/* sauve vol trapani 2eme config de vol   */

/**********  coefficients  pour  les  mesures  bolo    **********************************/
/*                         toutes les puissances en pW                                  */
/*	-1-	loi de reponse thermique des bolos  avec R en ohms et T en Kelvin               */
/*                                                                                      */
/* 	T =  coef2  *   (   ln (  R / coef1) **  ( -1 / coef0 )                             */
/*                                                                                      */
/*	-2-	fuite thermique du bolo   coef 3,4                                              */
/*                                                                                      */
/*	Ptot =  coef3  *  ( (10*Tb) ** coef4    -    (10*Tcryo)  **  coef4 )                */
/*                                                                                      */
/*	-3-	calcul empirique de Pciel et de  tau	  coef  5,6                             */
/*                                                                                      */
/*	Pciel	=	coef5	- Pelec		coef5= I * Ai (tables xavier) 	                    */
/*	tau	=	- ln ( 1 +  Pciel / coef6 )	coef6= I * Bi (tables xavier)                   */
/*   										                                            */
/* Pour les thermometres 1  4 (germanium et carbone Allan-Bradley) 		            */
/* les coefficients sont utiliss differemment, ils permettent de convertir	            */
/* R vers T		( c(6) est un offset sur la mesure de R par rapport  aux mesures 4 fils)*/
/*   llR= log(log(R - c(6))-c(0))  						                                */
/*    T	= exp(c(1) + c(2)* llR + c(3)* llR* llR + c(4)* llR* llR* llR +                 */
/*            c(5)* llR* llR* llR* llR)                                                 */
/*										                                                */
/*	version vol Trapani									                                */
/*	on corrige le biais de temperature coef2=1.1 old,  coef3=old/1.1^coef4	            */
/*										                                                */
/*										                                                */
/*										                                                */
/*										                                                */
/*										                                                */
/****************************************************************************************/


/**************************************************************************************/
/*                                                                                    */
/*   pour les MLPA      :  gain = 100   diviseur = 101  ou  330                       */
/*   pour les bebodiff  :  gain = diviseur = 100Kohm / R preampli                     */
/*   pour les bebodiff  :  la capa est corrigee d'un facteur 0.868                    */
/*   pour les cartes modifiees : mettre diviseur=0                                    */
/*                         et capa = la resistance de chage en Megohm                 */
/*                                                                                    */
/**************************************************************************************/


/*  numero_nom,  on/off  ,  0 = MLPA       , N bolo , gain_pa  , capa*1000 , diviseur , coef*10000 */
/*       ,  0 ou 1  ,  2..8 = BEBO    ,  hard   ,           ,  4700     ,  333     , 		*/
/*                     10 = Bediff    ,         ,           , 					*/

/* pour les bediff (code 10)  le n de bolo est  N de bebo*8  +  numero dans la bebo		*/
/*  soit :  1 2 3 4 5 6  ..  9 10 11 12 13 14 .. 17 18 19 20 21 22 .. etc			*/


/*debut_param*/
/*----------------------------------  fenetre :  -----------------------------------*/

/* ------------------------ configuration de vol 5 juillet 99-----------------------------*/
param_bolo  parametr={28,24,36,88,18,

{ 
{ 11 	, 2,10, 1 , 200, 22000	,  200 },	/*	1	*/
{  9	, 1,10, 2 , 200, 22000	,  200 },
{  8 	, 1,10, 3 , 200, 22000	,  200 },
{ 14 	, 2,10, 4 , 200, 22000	,  200 },

{  5	, 1,10, 5 ,1000,  4700	, 1000 },	/*	5	*/
{  0 	, 2,10, 6 ,1000,  4700	, 1000 },
{ 10	, 1,10, 9 ,1000,  4700	, 1000 },
{  0 	, 2,10,10, 1000,  4700	, 1000 },

{  2 	, 1,10,11, 1000,  4700	, 1000 },	/*	9	*/
{  4	, 1,10,12, 1000,  4700	, 1000 },
{  7 	, 2,10,13, 1000,  4700	, 1000 },
{  1 	, 1,10,14, 1000,  4700	, 1000 },

{ 13	, 1,10,17, 1000,  4700	, 1000 },	/*	13	*/
{  3	, 1,10,18, 1000,  4700	, 1000 },
{ 12    	, 1,10,19, 1000,  4700	, 1000 },
{  6	, 1,10,20, 1000,  4700	, 1000 },

{ 15	, 1,10,21,  200, 22000	,  200 },	/*	17	*/
{ 16	, 1,10,22,  200, 22000	,  200 },
{ 17	, 1,10,25,  500, 22000  ,  500 },
{ 18	, 2,10,26,  500, 22000  ,  500 },

{ 20	, 3,10,27, 1000, 22000	,    0 },	/*	21	*/
{ 21	, 3,10,28, 1000,  1000	,    0 },
{ 22	, 3,10,29, 1000,  1000	,    0 },
{ 23	, 3,10,30, 1000,  1000	,    0 },

},
{ 
{ "Niente   "    , { 5000  ,  0 , 0,   0,0,0,0} },			/*	0	*/
{ "ch1-bolo1"  , { 5000  ,  600000 , 154000,  63039, 25000, 0, 0}  },		/*	1	*/	
{ "ch1-bolo2"  , { 5000  ,  600000 , 154000,  47279, 25000, 0, 0}  },
{ "ch1-bolo3"  , { 5000  ,  600000 , 154000,  51219, 25000, 0, 0}  },
{ "ch2-bolo4"  , { 5000  ,  600000 , 154000,  70919, 25000, 0, 0}  },
{ "ch2-bolo5"  , { 5000  ,  600000 , 154000,  78799, 25000, 0, 0}  },	
{ "ch3-bolo6"  , { 5000  ,  600000 , 154000,  86678, 25000, 0, 0}  },

{ "Dum100mK1"  , { 5000  ,  588000 , 125000,  0,0,0,0} },			        /*	7	*/
{ "Dum100mK2"  , { 5000  ,  588000 , 125000,  0,0,0,0} },
/*{ "Dum100mK3"  , { 5000  , 1361800 , 125000,  0,0,0,0} },		*/
{ "Dum100mK4"  , { 5000  , 1361800 , 125000,  0,0,0,0} },		            /* 9 */
/*{ "Dum100mK5"  , { 5000  , 1361800 , 125000,  0,0,0,0} },		*/
{ "Dum100mK6"  , { 5000  , 1361800 , 125000,  0,0,0,0} },		

{ "Lou100mK1"  , { 5000  , 5680000 , 560000,  0,0,0,0} },                   /* 11 */
{ "Lou100mK2"  , { 5000  , 5680000 , 560000,  0,0,0,0} },
{ "Lou100mK3"  , { 5000  , 5680000 , 560000,  0,0,0,0} },
{ "Lou100mK4"  , { 5000  , 5680000 , 560000,  0,0,0,0} },

{ "Lou1.6K5 "  , { 5000  ,  0 , 0,   0,0,0,0} },        					/*	15	*/
{ "Lou1.6K6 "  , { 5000  ,  0 , 0,   0,0,0,0} },  
{ "Lou10K7  "  , { 5000  ,  0 , 0,   0,0,0,0} },  
{ "Lou10K8  "  , { 5000  ,  0 , 0,   0,0,0,0} }, 

{ "R10MOhm  "  , { 5000  ,  0 , 0,   0,0,0,0} },  							/*	19	*/

/* La germanium doit toujours etre en premier par rapport aux autres thermos absolus */
{ "germanium"  , {     0 ,  30719 ,   -910 , -16389 , 2927 ,   0,      0} }, /*	20	*/
{ "therm_4k"   , { 45000 ,  28907 , -16028 ,  -1327 , 1472 , 872,  52500} },
{ "therm_1.6k" , { 45000 ,  28907 , -16028 ,  -1327 , 1472 , 872, 566700} },
{ "therm_10k"  , { 45000 ,  28907 , -16028 ,  -1327 , 1472 , 872, 138100} },

}

};
/*fin_param*/

/* Definition Mai-Juin 1999
{ 
{ "v1-bedif1"  , 1,10,1 ,  200, 22000	,  200,  { 5000  , 123100 , 334200,0,0,0,0} },		
{ "v1-bedif2"  , 1,10,2 ,  200, 22000	,  200,  {  500  , 136180 ,   9010,0,0,0,0} },
{ "v1-bedif3"  , 1,10,3 ,  200, 22000	,  200,  {  500  , 136180 ,   9010,0,0,0,0} },
{ "v1-bedif4"  , 1,10,4 ,  200, 22000	,  200,  { 5000  , 123100 , 334200,0,0,0,0} },
{ "v1-bedif5"  , 1,10,5 , 1000, 4700	, 1000,  { 5000  , 123100 , 334200,0,0,0,0} },
{ "v1-bedif6"  , 1,10,6 , 1000, 4700	, 1000,  { 5000  , 123100 , 334200,0,0,0,0} },

{ "v1-bedif7"  , 1,10,9 , 1000, 4700	, 1000,  { 5000  , 123100 , 334200,0,0,0,0} },
{ "v1-bedif8"  , 1,10,10, 1000, 4700	, 1000,  { 5000  , 123100 , 334200,0,0,0,0} },
{ "v1-bedif9"  , 1,10,11, 1000, 4700	, 1000,  { 5000  , 123100 , 334200,0,0,0,0} },
{ "v1-bedif10" , 1,10,12, 1000, 4700	, 1000,  { 5000  , 123100 , 334200,0,0,0,0} },
{ "v1-bedif11" , 1,10,13, 1000, 4700	, 1000,  { 5000  , 123100 , 334200,0,0,0,0} },
{ "v1-bedif12" , 1,10,14, 1000, 4700	, 1000,  { 5000  , 123100 , 334200,0,0,0,0} },

{ "v1-bedif13"	, 1,10,17, 1000, 100000	, 1000,  { 5000  , 123100 , 334200,0,0,0,0} },
{ "v1-bedif14"	, 1,10,18, 1000, 470000	, 1000,  { 5000  , 123100 , 334200,0,0,0,0} },
{ "bedif15"  	, 1,10,19, 1000, 470000	, 1000,  {  500  ,  58800 ,  12500,0,0,0,0} },
{ "bedif16"	, 1,10,20, 1000,2200000	, 1000,  { 5000  , 123100 , 334200,0,0,0,0} },
{ "bedif17"	, 1,10,21, 1000, 4700	, 1000,  { 5000  , 123100 , 334200,0,0,0,0} },
{ "bedif18"	, 1,10,22, 1000, 4700	, 1000,  { 5000  , 123100 , 334200,0,0,0,0} },

{ "v1-bedif19"	, 2,10,25, 1000, 4700  	, 1000,  { 5000  , 123100 , 334200,0,0,0,0} },
{ "v1-bedif20"	, 2,10,26, 1000, 4700  	, 1000,  { 5000  , 123100 , 334200,0,0,0,0} },
{ "germanium"	, 3,10,27, 1000, 22000	,    0,  { 3500  ,  17100 , 646500,0,0,0,0} },
{ "therm_4k"	, 3,10,28, 1000, 1000	,    0,  {12000  ,1804000 ,  72800,0,0,0,0} },
{ "therm_1.6k"	, 3,10,29, 1000, 1000	,    0,  {12000  ,1804000 ,  72800,0,0,0,0} },
{ "therm_10k"	, 3,10,30, 1000, 1000	,    0,  {12000  ,1804000 ,  72800,0,0,0,0} },

}*/

/* bolos campagne 1998-1999	*/
/*
reg_NbSi.J, 1, 0, 1, 100, 4.7, 333,	.5			,519.6  , 8.286
v1-231...L, 1, 0, 2, 100, 4.7, 333, .5   , 1.7   , 32.41 , 0.333 , 10  , 20.30  ,  11.41  		
v1-232...N, 1, 0, 3, 100, 4.7, 333,		
v1-237...E, 1, 0, 4, 100, 4.7, 333,

reg_JamieO, 1, 0, 5, 100, 4.7, 101,

V2-NbSi..H, 1, 0, 6, 100, 4.7, 101, .5   ,433.8  , 9.25
V2-230...B, 1, 0, 7, 100, 4.7, 333, .5   , 8.26  , 26.61 , 5.10  ,  7  , 9.354   ,  1.026
V2-205...Q, 1, 0, 8, 100, 4.7, 333,	.518 , 81    , 25.2 
V2-208...P, 1, 0, 9, 100, 4.7, 333, .5   , 12.31 , 33.42 , 0.627 , 6.5 , 8.113   ,  2.958

*/
/*bolos campagne 1997-1998	*/
/*

v1-208...J, 1, 0, 1, 100, 4.7, 333, .5   , 12.31 , 33.42 		
v1-232...L, 1, 0, 2, 100, 4.7, 333,		
v1-205...N, 1, 0, 3, 100, 4.7, 333,	.518 , 81    , 25.2	
v1-NbSi..E, 1, 0, 4, 100, 4.7, 333,	.5			,519.6  , 8.286
Jamie....O, 1, 0, 5, 100, 4.7, 101,
V2-NbSi..H, 1, 0, 6, 100, 4.7, 101, .5   ,433.8  , 9.25
V2-224...B, 1, 0, 7, 100, 4.7, 333, .5   ,3.43   , 26.6
V2-230...Q, 1, 0, 8, 100, 4.7, 333, .5   , 8.26  , 26.61
V2-231...P, 1, 0, 9, 100, 4.7, 333, .5   , 1.7   , 32.41

*/


int mode_transmission_telemesure[nb_modes_telemesure][nb_type_blocks]= {

/* enregisteur de bord flash :  plafond standard nominal	*/
/* 0*/	{ 0,10,15,50, 10,50, 0, 0, 0, 1, 0, 0, 1, 0, 1,2500, 0, 0, 0, 0},

/* 1*/	{ 0,10,10, 1, 10, 3, 0, 0, 0, 1, 0, 0, 1, 0, 4,2500, 0, 0, 0, 0},

/* 2*/	{ 0,10,05,01, 10,06, 0, 0, 0, 1, 0, 0, 1, 0, 2,2500, 0, 0, 0, 0},

/* 3*/	{ 0,10, 1,25, 10, 2, 0, 0, 0, 0, 0, 0, 1, 0, 0,2500, 0, 0, 0, 0},

/* 4*/	{ 0,10,15,50, 10,25, 0, 0, 1, 0, 0, 0, 0, 0, 0,2500, 0, 0, 0, 0},

/* 5*/	{ 0,10,15,50, 10,25, 0, 0, 0, 0, 1, 0, 0, 0, 0,2500, 0, 0, 0, 0},

/* 6*/	{ 0,10,15,50, 10,50, 0, 0, 0, 1, 0, 0, 1, 0, 2,2500, 0, 0, 0, 0},

/* 7*/	{ 0,10,15,50,100,50, 1, 1, 0, 1, 0, 0, 1, 0, 1,2500, 0, 0, 0, 0},

/* 8*/	{ 0,10,15,50,100,50, 1, 1, 1, 0, 0, 0, 0, 0, 0,2500, 0, 0, 0, 0},

/* 9*/	{ 0,10, 1, 1,100, 1, 0, 0, 0, 0, 0, 0, 1, 0, 0,2500, 0, 0, 0, 0}

 };



int mode_transmission_flash[nb_modes_flash][nb_type_blocks]= {


/* enregisteur de bord flash : nominal	*/
/* 0*/	{ 0,50,15,25, 10,25, 0, 0, 0, 1, 0, 0, 1, 0, 1,2500, 0, 0, 0, 0} ,

/* enregisteur de bord flash : minimum	*/
/* 1*/	{ 0,50,50,50,50,100, 0, 0, 0, 0, 0, 0, 0, 0, 0,2500, 0, 0, 0, 0} ,

/* enregisteur de bord flash :  rien	*/
/* 2*/	{ 0, 0, 0, 0,  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0} };




/*debut_nom_reglage*/
/* 0->1 - demarrage par defaut - Nominal*/
/* 1->2 - idem*/
/* 2->3 - faible courant*/
/* 3->4 - fort courant*/
/* 4->5 - non fffdfini*/
/* 5->6 - non dfini*/
/* 6->7 - non dfini*/
/* 7->8 - non dfini*/
/*fin_nom_reglage*/
































reglage_bolo  reglage_standard[8]={{


/*debut reglage 0 */
#ifdef programme
{32,76,8,1},{
{20,0}
,{1311522837,256000}
,{1048576021,256004}
,{20,0}
,{1048576021,256001}
,{20,0}
,{262144021,128003}
,{20,0}
,{262144021,128001}
,{262144021,128001}
,{20,0}
,{1048576021,256257}
,{1048576021,256003}
,{262144021,128001}
,{262144789,128001}
,{262144021,128001}
,{100663317,256002}
,{100716053,155650}
,{1048576277,256003}
,{20,0}
,{1024021,0}
,{262165,0}
,{65557,0}
,{1024020,0}
},{
{1,21,16,4}
,{1,21,13,4}
,{1,21,20,4}
,{1,21,20,4}
,{0,21,0,4}
,{0,21,0,4}
},{
{3,1,21,24,21,24,0}
,{0,1,9,1,0,0,0}
,{0,1,9,1,0,0,0}
,{6,1,9,34,30,0,65326}
},{5,3,129,108,0,126,104,88} 
#else
{1,8,76,32},{
{20,0}
,{1311522837,256000}
,{1048576021,256004}
,{20,0}
,{1048576021,256001}
,{20,0}
,{262144021,128003}
,{20,0}
,{262144021,128001}
,{262144021,128001}
,{20,0}
,{1048576021,256257}
,{1048576021,256003}
,{262144021,128001}
,{262144789,128001}
,{262144021,128001}
,{100663317,256002}
,{100716053,155650}
,{1048576277,256003}
,{20,0}
,{1024021,0}
,{262165,0}
,{65557,0}
,{1024020,0}
},{
{4,16,21,1}
,{4,13,21,1}
,{4,20,21,1}
,{4,20,21,1}
,{4,0,21,0}
,{4,0,21,0}
},{
{24,21,1,3,0,24,21}
,{1,9,1,0,0,0,0}
,{1,9,1,0,0,0,0}
,{34,9,1,6,65326,0,30}
},{108,129,3,5,88,104,126,0} 
#endif
/*fin_reglage*/


},{

/*debut reglage 1 */
#ifdef programme
{32,76,8,1},{
{20,0}
,{1311522837,256000}
,{1048576021,256004}
,{20,0}
,{1048576021,256001}
,{20,0}
,{262144021,128003}
,{20,0}
,{262144021,128001}
,{262144021,128001}
,{20,0}
,{1048576021,256257}
,{1048576021,256003}
,{262144021,128001}
,{262144789,128001}
,{262144021,128001}
,{100663317,256002}
,{100716053,155650}
,{1048576277,256003}
,{20,0}
,{1024021,0}
,{262165,0}
,{65557,0}
,{1024020,0}
},{
{1,21,16,4}
,{1,21,13,4}
,{1,21,20,4}
,{1,21,20,4}
,{0,21,0,4}
,{0,21,0,4}
},{
{3,1,21,24,21,24,0}
,{0,1,9,1,0,0,0}
,{0,1,9,1,0,0,0}
,{6,1,9,34,30,0,65326}
},{5,3,129,108,0,126,104,88} 
#else
{1,8,76,32},{
{20,0}
,{1311522837,256000}
,{1048576021,256004}
,{20,0}
,{1048576021,256001}
,{20,0}
,{262144021,128003}
,{20,0}
,{262144021,128001}
,{262144021,128001}
,{20,0}
,{1048576021,256257}
,{1048576021,256003}
,{262144021,128001}
,{262144789,128001}
,{262144021,128001}
,{100663317,256002}
,{100716053,155650}
,{1048576277,256003}
,{20,0}
,{1024021,0}
,{262165,0}
,{65557,0}
,{1024020,0}
},{
{4,16,21,1}
,{4,13,21,1}
,{4,20,21,1}
,{4,20,21,1}
,{4,0,21,0}
,{4,0,21,0}
},{
{24,21,1,3,0,24,21}
,{1,9,1,0,0,0,0}
,{1,9,1,0,0,0,0}
,{34,9,1,6,65326,0,30}
},{108,129,3,5,88,104,126,0} 
#endif
/*fin_reglage*/

},{

/*debut reglage 2 */
#ifdef programme
{32,76,8,1},{
{20,0}
,{100721941,256000}
,{1048607509,256004}
,{20,0}
,{1048586773,256003}
,{20,0}
,{50335509,128001}
,{20,0}
,{50331669,128001}
,{50336789,128001}
,{20,0}
,{1048622101,256259}
,{1048635413,256003}
,{50331669,128001}
,{50352661,128001}
,{50337813,128001}
,{100665109,256002}
,{100664597,155650}
,{1048600341,256003}
,{20,0}
,{1024021,0}
,{65557,0}
,{65557,0}
,{262165,0}
},{
{1,21,11,4}
,{1,21,13,4}
,{1,21,20,4}
,{1,21,20,4}
,{0,20,0,1}
,{0,20,0,1}
},{
{3,1,21,24,21,24,0}
,{0,1,9,1,0,0,0}
,{0,1,9,1,0,0,0}
,{6,17,0,34,30,0,65386}
},{5,3,129,108,0,126,104,88} 
#else
{1,8,76,32},{
{20,0}
,{100721941,256000}
,{1048607509,256004}
,{20,0}
,{1048586773,256003}
,{20,0}
,{50335509,128001}
,{20,0}
,{50331669,128001}
,{50336789,128001}
,{20,0}
,{1048622101,256259}
,{1048635413,256003}
,{50331669,128001}
,{50352661,128001}
,{50337813,128001}
,{100665109,256002}
,{100664597,155650}
,{1048600341,256003}
,{20,0}
,{1024021,0}
,{65557,0}
,{65557,0}
,{262165,0}
},{
{4,11,21,1}
,{4,13,21,1}
,{4,20,21,1}
,{4,20,21,1}
,{1,0,20,0}
,{1,0,20,0}
},{
{24,21,1,3,0,24,21}
,{1,9,1,0,0,0,0}
,{1,9,1,0,0,0,0}
,{34,0,17,6,65386,0,30}
},{108,129,3,5,88,104,126,0} 
#endif
/*fin_reglage*/

},{

/*debut reglage 3 */
#ifdef programme
{32,76,8,1},{
{20,0}
,{100721941,256000}
,{1048607509,256004}
,{20,0}
,{1048586773,256003}
,{20,0}
,{524291861,128001}
,{20,0}
,{524288021,128001}
,{524293141,128001}
,{20,0}
,{1048622101,256259}
,{1048635413,256003}
,{524288021,128001}
,{524309013,128001}
,{524294165,128001}
,{100665109,256002}
,{100664597,155650}
,{1048600341,256003}
,{20,0}
,{1024021,0}
,{65557,0}
,{65557,0}
,{65557,0}
},{
{1,21,18,4}
,{1,21,13,4}
,{1,21,20,4}
,{1,21,20,4}
,{0,20,0,1}
,{0,20,0,1}
},{
{3,1,21,24,21,24,0}
,{0,1,9,1,0,0,0}
,{0,1,9,1,0,0,0}
,{6,17,0,34,30,0,65386}
},{5,3,129,108,0,126,104,88} 
#else
{1,8,76,32},{
{20,0}
,{100721941,256000}
,{1048607509,256004}
,{20,0}
,{1048586773,256003}
,{20,0}
,{524291861,128001}
,{20,0}
,{524288021,128001}
,{524293141,128001}
,{20,0}
,{1048622101,256259}
,{1048635413,256003}
,{524288021,128001}
,{524309013,128001}
,{524294165,128001}
,{100665109,256002}
,{100664597,155650}
,{1048600341,256003}
,{20,0}
,{1024021,0}
,{65557,0}
,{65557,0}
,{65557,0}
},{
{4,18,21,1}
,{4,13,21,1}
,{4,20,21,1}
,{4,20,21,1}
,{1,0,20,0}
,{1,0,20,0}
},{
{24,21,1,3,0,24,21}
,{1,9,1,0,0,0,0}
,{1,9,1,0,0,0,0}
,{34,0,17,6,65386,0,30}
},{108,129,3,5,88,104,126,0} 
#endif
/*fin_reglage*/

},{

/*debut reglage 4 */
#ifdef programme
{39,62,9,1},{
{20,0}
,{-100659180,229382}
,{-100659436,294918}
,{20,0}
,{-100663276,221189}
,{-100663276,5}
,{-100659436,245762}
,{-100663276,5}
,{-100658154,245761}
,{-100658156,253954}
,{20,0}
,{-100663276,204805}
,{-100663276,16389}
,{-100656874,1}
,{-100656874,16385}
,{-100663276,3}
,{-100506347,6}
,{-100509675,6}
,{-100372972,6}
,{2097174,0}
,{1024022,0}
,{16406,0}
,{4117,0}
,{262164,0}
},{
{2,22,24,1}
,{1,20,24,4}
,{0,20,24,4}
,{0,20,24,3}
,{0,20,24,4}
,{0,20,24,4}
},{
{0,1,9,1,0,0,0}
,{0,1,9,1,0,0,0}
,{0,1,9,1,0,0,0}
,{0,1,9,1,0,0,0}
},{2,3,129,108,2,126,104,88} 
#else
{1,9,62,39},{
{20,0}
,{-100659180,229382}
,{-100659436,294918}
,{20,0}
,{-100663276,221189}
,{-100663276,5}
,{-100659436,245762}
,{-100663276,5}
,{-100658154,245761}
,{-100658156,253954}
,{20,0}
,{-100663276,204805}
,{-100663276,16389}
,{-100656874,1}
,{-100656874,16385}
,{-100663276,3}
,{-100506347,6}
,{-100509675,6}
,{-100372972,6}
,{2097174,0}
,{1024022,0}
,{16406,0}
,{4117,0}
,{262164,0}
},{
{1,24,22,2}
,{4,24,20,1}
,{4,24,20,0}
,{3,24,20,0}
,{4,24,20,0}
,{4,24,20,0}
},{
{1,9,1,0,0,0,0}
,{1,9,1,0,0,0,0}
,{1,9,1,0,0,0,0}
,{1,9,1,0,0,0,0}
},{108,129,3,2,88,104,126,2} 
#endif
/*fin_reglage*/

},{

/*debut reglage 5 */
#ifdef programme
{39,68,9,1},{
{20,0}
,{1048982293,229382}
,{1049128469,253958}
,{20,0}
,{1048966677,245765}
,{20,0}
,{262157846,245762}
,{1048919829,5}
,{262156054,245761}
,{262154006,253954}
,{20,0}
,{1049123349,229381}
,{1049157141,237573}
,{262154262,1}
,{262158614,16385}
,{262149654,3}
,{262750740,237572}
,{262606612,122884}
,{-1174095083,139270}
,{20,0}
,{16406,0}
,{16406,0}
,{4117,0}
,{262164,0}
},{
{1,22,16,1}
,{1,22,16,4}
,{1,22,16,4}
,{1,20,16,3}
,{1,21,20,4}
,{1,21,20,4}
},{
{0,1,9,1,0,0,0}
,{0,1,9,1,0,0,0}
,{0,1,9,1,0,0,0}
,{0,1,9,1,0,0,0}
},{2,3,129,108,3,126,104,88} 
#else
{1,9,68,39},{
{20,0}
,{1048982293,229382}
,{1049128469,253958}
,{20,0}
,{1048966677,245765}
,{20,0}
,{262157846,245762}
,{1048919829,5}
,{262156054,245761}
,{262154006,253954}
,{20,0}
,{1049123349,229381}
,{1049157141,237573}
,{262154262,1}
,{262158614,16385}
,{262149654,3}
,{262750740,237572}
,{262606612,122884}
,{-1174095083,139270}
,{20,0}
,{16406,0}
,{16406,0}
,{4117,0}
,{262164,0}
},{
{1,16,22,1}
,{4,16,22,1}
,{4,16,22,1}
,{3,16,20,1}
,{4,20,21,1}
,{4,20,21,1}
},{
{1,9,1,0,0,0,0}
,{1,9,1,0,0,0,0}
,{1,9,1,0,0,0,0}
,{1,9,1,0,0,0,0}
},{108,129,3,2,88,104,126,3} 
#endif
/*fin_reglage*/

},{

/*debut reglage 6 */
#ifdef programme
{197,191,175,185},{
{0,0}
,{0,0}
,{0,0}
,{0,0}
,{0,0}
,{0,0}
,{0,0}
,{0,0}
,{0,0}
,{0,0}
,{0,0}
,{0,0}
,{0,0}
,{0,0}
,{0,0}
,{0,0}
,{0,0}
,{0,0}
,{0,0}
,{0,0}
,{0,0}
,{0,0}
,{0,0}
,{0,0}
},{
{106,98,93,71}
,{66,74,87,66}
,{48,46,38,33}
,{40,41,33,26}
,{25,29,40,57}
,{63,62,71,80}
},{
{83,79,75,75,92,112,31100}
,{125,126,117,113,107,94,20315}
,{108,116,122,124,117,120,32117}
,{110,99,94,98,107,93,17217}
},{88,82,94,108,111,126,104,88} 
#else
{185,175,191,197},{
{0,0}
,{0,0}
,{0,0}
,{0,0}
,{0,0}
,{0,0}
,{0,0}
,{0,0}
,{0,0}
,{0,0}
,{0,0}
,{0,0}
,{0,0}
,{0,0}
,{0,0}
,{0,0}
,{0,0}
,{0,0}
,{0,0}
,{0,0}
,{0,0}
,{0,0}
,{0,0}
,{0,0}
},{
{71,93,98,106}
,{66,87,74,66}
,{33,38,46,48}
,{26,33,41,40}
,{57,40,29,25}
,{80,71,62,63}
},{
{75,75,79,83,31100,112,92}
,{113,117,126,125,20315,94,107}
,{124,122,116,108,32117,120,117}
,{98,94,99,110,17217,93,107}
},{108,94,82,88,88,104,126,111} 
#endif
/*fin_reglage*/

},{

/*debut reglage 7 */
#ifdef programme
{197,191,175,185},{
{0,0}
,{0,0}
,{0,0}
,{0,0}
,{0,0}
,{0,0}
,{0,0}
,{0,0}
,{0,0}
,{0,0}
,{0,0}
,{0,0}
,{0,0}
,{0,0}
,{0,0}
,{0,0}
,{0,0}
,{0,0}
,{0,0}
,{0,0}
,{0,0}
,{0,0}
,{0,0}
,{0,0}
},{
{106,98,93,71}
,{66,74,87,66}
,{48,46,38,33}
,{40,41,33,26}
,{25,29,40,57}
,{63,62,71,80}
},{
{83,79,75,75,92,112,31100}
,{125,126,117,113,107,94,20315}
,{108,116,122,124,117,120,32117}
,{110,99,94,98,107,93,17217}
},{88,82,94,108,111,126,104,88} 
#else
{185,175,191,197},{
{0,0}
,{0,0}
,{0,0}
,{0,0}
,{0,0}
,{0,0}
,{0,0}
,{0,0}
,{0,0}
,{0,0}
,{0,0}
,{0,0}
,{0,0}
,{0,0}
,{0,0}
,{0,0}
,{0,0}
,{0,0}
,{0,0}
,{0,0}
,{0,0}
,{0,0}
,{0,0}
,{0,0}
},{
{71,93,98,106}
,{66,87,74,66}
,{33,38,46,48}
,{26,33,41,40}
,{57,40,29,25}
,{80,71,62,63}
},{
{75,75,79,83,31100,112,92}
,{113,117,126,125,20315,94,107}
,{124,122,116,108,32117,120,117}
,{98,94,99,110,17217,93,107}
},{108,94,82,88,88,104,126,111} 
#endif
/*fin_reglage*/

} };

/* ------------------------------------   corps  des fonctions	 ------------------------------ */
/* -------------------------------------------------------------------------------------------- */


/*
unsigned int4	val_long(char x)
{
unsigned long a,xl;
char aa;
aa=x-2;
a=aa;
if(x<3)  xl=x;	else	xl=((a&1) + 2)<<(a>>1);
return(xl);
}



double	val_double(char x)
{
unsigned long a,xl;
if(x<0) x=-x;	a=x;	if(!a)  xl=0;	else	xl=((a&1) + 2)<<(a>>1);
if(x>0)	return(1e-4*(double)xl);	else	return(-1e-4*(double)xl);
}

int	new_val_dac(int a,char  code)
{
if(code&0x80)	a=(code&0x7f) <<5 ;
else	{
	if(code&0x40)	a+=code&0x3f;	
	else		a-=code&0x3f;	
	}
return(a);
}

*/


int	calcul_somme_block(block_type_modele* blk,int longueur)
{
int i,so=0;;
for(i=0;i<(longueur/4-4);i++)  so^=(int)blk->mot[i];
/* somme sur tous les mots internes	: on exclus le dbut, les codes et la fin	*/
return((so^(so>>16))&0xffff);
}




void  valide_block(block_type_modele* blk,int type,int block_num)
{
int somme,longueur;
def_long_block
longueur=long_block[type];
/*printf("valide block adresse %x  type %d  numblock %d  longueur=%d \n" */
/* 		,(unsigned)blk,type,block_num,longueur);*/
blk->debut		=	debut_block_mesure;
somme=0;blk->code1		=	(((long)longueur)<<16)	|	somme;
blk->code2		=	(((long)block_num) & 0xffffff ) | ( (((long)type)<<24)&0xff000000 );

blk->mot[longueur/4-4]  =	fin_block_mesure;

#if defined(_ECC_LIB_H_)
{
int place_ecc;
place_ecc=(longueur-4-ECC_SIZE-SIZE_HEAD-((longueur-4-SIZE_HEAD)/ECC_TOTAL)*ECC_SIZE)/4;
SetEcc( blk, (unsigned char *) &(blk->mot[place_ecc] ) ) ;
}
#endif

somme=calcul_somme_block(blk,longueur);
blk->code1		=	(((long)longueur)<<16)	|	somme;
/* l'ecc est faux car on a change la somme: mettre la somme a zero avant de tester ecc  */
}

/* Quand on est sur une machine swappee, on ne cherche pas a verifier */
/* le checksum, puisqu'on a modifie les blocs, sans swapper par exemple */
/* les chars des noms de bolometres et des chaines GPS... */
#ifdef __alpha
#define SWAP
#endif
#if defined(Linux)  || defined(linux)
#define SWAP
#endif



int  verifie_block(block_type_modele* blk)
{
int type,lg,som;
def_long_block
if(blk->debut != debut_block_mesure)					return(block_debut_erreur);
type=type_block(blk);		if( (type<0) ||(type>=nb_type_blocks) )	return(block_type_inconnu);	
lg=longueur_block(blk);		if( lg != long_block[type] )		return(block_longueur_erreur);	
if( blk->mot[(lg/4)-4]  !=	fin_block_mesure)			return(block_fin_erreur);	
#ifndef SWAP
som=calcul_somme_block(blk,lg); if( som!= somme_block(blk))		return(block_somme_erreur);
#endif
return(block_correct);
}


int  verifie_block_printf(block_type_modele* blk)
{
int type,lg,som;
def_long_block
def_nom_block
if(blk->debut != debut_block_mesure)
	{
	printf(" erreur dans le code debut de block	 \n");
	return(block_debut_erreur);
	}	

type=type_block(blk);
if( (type<0) || (type>nb_type_blocks) )	
	{
	printf(" block de type %d  inconnu\n",type);
	return(block_type_inconnu);
	}

lg=longueur_block(blk);
if( lg!=long_block[type] )	
	{
	printf(" block type %s  erreur de longueur (nominal=%d , dans le block=%d \n"
			,nom_block[type],long_block[type],lg);
	return(block_longueur_erreur);
	}

som=calcul_somme_block(blk,lg);
if( som!=somme_block(blk) )	
	{
	printf(" block type %s   :  erreur de somme (calculee=%d , dans le block=%d \n"
			,nom_block[type],som,somme_block(blk) );
	return(block_somme_erreur);
	}
	
if(blk->mot[(lg/4)-4]	!= fin_block_mesure)	
	{
	printf(" block type %s  erreur de code fin de block : trouve %x au lieu de %x \n"
			,nom_block[type],(int)blk->mot[(lg/4)-4],fin_block_mesure);
	return(block_fin_erreur);
	}

return(block_correct);
}





