// temporaire, positionnement en utilisant la galaxie...

#ifndef TEMPLOCATOR_H
#define TEMPLOCATOR_H

class TempLocator {
public:
  TempLocator();

  void setEarthPos(double lon, double lat);
  void setTSid(double ts);
  
  double getAlphaZenith();
  double getDeltaZenith();
  
      
  double getAzimutBolo(int sampleNum, int ibolo); // ibolo, comme dans les TOI
  double getElvBolo(int sampleNum, int ibolo);
  double getAlphaBolo(int sampleNum, int ibolo);
  double getDeltaBolo(int sampleNum, int ibolo);
  double getAlphaCenter(int sampleNum);
  double getDeltaCenter(int sampleNum);
  
  void getAltAzBolo(int sampleNum, int ibolo, double& elv, double& az);

protected:
  double lon; // degrees  +=EST
  double lat; // degrees  +=NORD
  double ts;  // secondes 
  
  int    nGalCross;
  long*   crossings; // samplenum des croisements galactiques
  
  double raZ;  //zenith
  double decZ; //zenith
  int xSampleNum; // pour le dernier calcul
  double azimBolGC;
  
  void findGeomFromGC(int sampleNum); // pour le bolo qui voit les xing
    // il faut avoir positionne lon, lat et ts.
  void ComputeZenith();
};

extern TempLocator tempLocator;

#endif
