// toisvr.cc
// Eric Aubourg         CEA/DAPNIA/SPP   juillet 1999

#include <iostream.h>
#include "toisvr.h"
#include "archparam.h"
#include "asigps.h"



TOISvr::TOISvr()
{
  initDone = false;
}

// To avoid special copy constructor handling, we will not
// register ourself to us... Special dealing in readReq.

void TOISvr::setDirectory(string d) {
  iter.directory = d;
}

void TOISvr::addFile(string f) {
  iter.files.insert(f);
}

void TOISvr::useAuxGPS(AuxGPS* gps) {
  if (iter.auxGPS) delete iter.auxGPS;
  iter.auxGPS = gps;
}


void TOISvr::onBoardRecorderFiles(bool x) {
  iter.isOnBoardRecorder = x;
}

  
void TOISvr::setMJDInterval(double tStart, double tEnd) {
  if (tStart>0) iter.tStart = tStart;
  if (tEnd>0)   iter.tEnd = tEnd;
}

void TOISvr::setUTCInterval(double tStart, double tEnd) {
  if (tStart>0) iter.utcStart = tStart;
  if (tEnd>0)   iter.utcEnd = tEnd;
}

void TOISvr::setSNInterval(long tStart, long tEnd) {
  if (tStart>0) iter.sStart = tStart;
  if (tEnd>0)   iter.sEnd = tEnd;
}


void TOISvr::setUnderSample(int n) {
  if (n<=1) n=1;
  iter.underSample = n;
}

  
void TOISvr::addInfo(TOIKind kind, int index, bool triggering, bool interp) {
  TOIIter::info i;
  i.kind = kind; 
  i.index = index;
  i.triggering = triggering;
  i.interpolated= interp;
  iter.infos.push_back(i);
}

void TOISvr::addInfo(TOIKind kind, bool triggering, bool interp) {
  addInfo(kind,0,triggering,interp);
}
  
TOIIter TOISvr::doQuery() {
  //iter.Init();
  return iter;
}

void TOISvr::registerReqHandler(RequestHandler* h) {
  handlers.push_back(h);
}


void TOISvr::readReq(istream& str) {
   if (!initDone) defaultInclude();
   string line;
   while (str) {
     getline(str,line);
     if (!str) break;
     if (line.substr(0,4)=="#END") break;
     if (line[0] != '@' && line[0] != '#') continue;
     bool handled=processRequest(line); 
     if (!handled) {
        cerr << "*Warning, unrecognized directive " << line << endl;
     }
   }
}

#define tsttoi(toi)   if (keyw == "@"#toi) kind = toi;

bool TOISvr::processRequest(string line) {
  int x = line.find(' ');
  string keyw = line.substr(0, x);
  string args = (x>0) ? line.substr(x) : string("");
  if (keyw[0] == '#') {
     bool handled = processOption(keyw,args);
     for (list<RequestHandler*>::iterator i = handlers.begin(); 
          i != handlers.end(); i++) {
       handled |= (*i)->processOption(keyw,args);
     }
     return handled;
  }
  if (keyw[0] == '@') {
	// find TOI kind, index and options
    TOIKind kind= (TOIKind)-1;
    int index=-1;
    bool interp=false;
    bool repet =false;
    bool flag  =false;
    bool notrig=false;
    tsttoi(sampleNum)
    else tsttoi(internalTime)
    else tsttoi(mjd)
    else tsttoi(mutc)
    else tsttoi(boloMuV)
    else tsttoi(boloMuV2)
    else tsttoi(boloRawMuV)
    else tsttoi(boloRes)
    else tsttoi(boloTemp)
    else tsttoi(boloGainAmpli)
    else tsttoi(boloDACV)
    else tsttoi(boloDACI)
    else tsttoi(boloMuV2T)
    else tsttoi(boloRawMuVCN)
    else tsttoi(dilDAC)
    else tsttoi(dilSwitch)
    else tsttoi(serviceTemp)
    else tsttoi(sstDiode)
    else tsttoi(sstChannel)
    else tsttoi(sstDiodeCN)
    else tsttoi(sstChannelCN)
    else tsttoi(sstStarCnt)
    else tsttoi(sstStarZ)
    else tsttoi(sstStarF)
    else tsttoi(sstStarT)
    else tsttoi(gyroRaw)
    else tsttoi(gyroV)
    else tsttoi(gyroSpeed)
    else tsttoi(gpsTime)
    else tsttoi(longitude)
    else tsttoi(latitude)
    else tsttoi(altitude)
    else tsttoi(tsid)
    else tsttoi(azimuthBolo)
    else tsttoi(alphaRotAxis)
    else tsttoi(deltaRotAxis)
    else tsttoi(alphaSst)
    else tsttoi(deltaSst)
    else tsttoi(alphaZenith)
    else tsttoi(deltaZenith)
    else tsttoi(alphaFPAxis)
    else tsttoi(deltaFPAxis)
    else tsttoi(alphaBolo)
    else tsttoi(deltaBolo)
    else {
      // cerr << "*Warning, unrecognized TOI " << line << endl;
      return false;
    }
    if (kind  == sampleNum || kind == mjd || kind == mutc) notrig = true;
    string toiname = keyw.substr(1); 
    while (args != "") {
      if (args[0] == ' ') {
        x = args.find_first_not_of(' ');
        if (x==string::npos) break;
        args = args.substr(x);
        if (args == "") break;
      }
      x = args.find(' ');
      string opt = args.substr(0, x);
      args = (x>0) ? args.substr(x) : string("");
      if (opt[0]>='0' && opt[0]<='9') {
        index = atoi(opt.c_str());
      } else if (opt == "notrig") {
        notrig = true;
      } else if (opt == "repet") {
        repet = true; interp = false;
      } else if (opt == "interp") {
        interp = true; repet = false;
      } else if (opt == "flag") {
        flag = true;
      }
    }
    bool handled = processTOIReq(line, toiname, kind, index, interp, repet, flag, notrig);
    for (list<RequestHandler*>::iterator i = handlers.begin(); 
         i != handlers.end(); i++) {
      handled |= (*i)->processTOIReq(line, toiname, kind, index, interp, repet, flag, notrig);
    }
    return handled;
  }
  return false;
}


bool TOISvr::processTOIReq(string /*line*/, string /*toiname*/, TOIKind kind, int index, 
                           bool interp, bool /*repet*/, bool /*flag*/, bool notrig)
{
  if (index<0) index=0;
  addInfo(kind, index, !notrig, interp);
  return true;
} 

bool TOISvr::processOption(string key, string arg)
{
  if (arg.length()>0 && arg[0] == ' ') {
    arg = arg.substr(arg.find_first_not_of(' '));
  }
  if (key == "#MJDRANGE") {
    double tmin, tmax;
    sscanf(arg.c_str(), "%lg %lg", &tmin, &tmax);
    setMJDInterval(tmin, tmax);
  } else if (key == "#UTCRANGE") {
    double tmin, tmax;
    sscanf(arg.c_str(), "%lg %lg", &tmin, &tmax);
    setUTCInterval(tmin, tmax);
  } else if (key == "#SNRANGE") {
    long tmin, tmax;
    sscanf(arg.c_str(), "%ld %ld", &tmin, &tmax);
    setSNInterval(tmin, tmax);
  } else if (key == "#PATH") {
    setDirectory(arg);
  } else if (key == "#FILE") {
    addFile(arg);
  } else if (key == "#UNDERSAMPLE") {
    setUnderSample(atoi(arg.c_str()));
  } else if (key == "#RECORDER") {
    onBoardRecorderFiles(true);
  } else if (key == "#MJD0") {
    double t0;
    sscanf(arg.c_str(), "%lg", &t0);
    archParam.acq.tBlock0 = t0;
  } else if (key == "#UTCORIGIN") {
    double t0;
    sscanf(arg.c_str(), "%lg", &t0);
    archParam.acq.utcOrigin = t0;
  } else if (key == "#PERECH") {
    double t0;
    sscanf(arg.c_str(), "%lg", &t0);
    archParam.acq.perEch = t0;
  } else if (key == "#ASIGPS") {
    ASIGPS* gps = new ASIGPS(arg);
    gps->FitsDump("GPSDump.fits");
    useAuxGPS(gps);
  } else if (key == "#INCLUDE") {
    ifstream f(arg.c_str());
    readReq(f);
  } else {
    // cerr << "*Warning, unrecognized option " << line << endl;
    return false;
  }
  return true;
}

void TOISvr::defaultInclude() {
  initDone = true;
  processRequest("#REQVERSION V_240999");
  processRequest("#MJD0 1376.8358818");
  processRequest("#PERECH 0.005836818076");
  processRequest("#UTCORIGIN 1376.5");
  processRequest("#ASIGPS ASI_GPS_archeops1999.ascii");
  processRequest("#COMMENT Archtoi -- 23 september 1999 -- Eric Aubourg CEA/DAPNIA");
  processRequest("#COMMENT ***WARNING***");
  processRequest("#COMMENT ***SOME TOI'S ARE PRELIMINARY***");
  processRequest("#COMMENT gyroSpeed is not calibrated");
  processRequest("#COMMENT azimut/alpha/delta use galaxy crossings and ASI GPS data");
  processRequest("#COMMENT and assume no pendulation");
  processRequest("#COMMENT boloTens2 is not protected against glitches");
  processRequest("#COMMENT sst software has not been updated to last DY code");
  processRequest("#COMMENT trajectory info only while italian TM got GPS info");
  
}
