/* $Id: dirent.h,v 1.1.1.1 1999-05-25 08:25:53 ansari Exp $ */

#ifndef _DIRENT_H
#define _DIRENT_H

#include <stat.h>

typedef unsigned short			ushort_t;

typedef struct {
	short volrefnum;
	long dirid;
	int nextfile;
} DIR;

struct dirent {
    ino_t    d_ino;               /* file number of entry */
    ushort_t d_reclen;            /* length of this record */
    ushort_t d_namlen;            /* length of string in d_name */
	char d_name[FILENAME_MAX];
};

#ifdef __cplusplus
extern "C" {
#endif

DIR *opendir(char const *);
struct dirent *readdir(DIR *);
int closedir(DIR *);
void rewinddir(DIR*);
//long telldir(DIR *);
//void seekdir(DIR *, long);

#ifdef __cplusplus
}
#endif

#endif