#include "dyffttools.h"


//	Librairie FFTMayer enrobe pour etre utilisable facilement en C++
// 	Un debut : D. Yvon 07/99


// Fonction de fenetrage D. Yvon
// Cut est la fraction du tableau ou l'on effectue le bizeau pour imposer 
// par continuite une amplitude zero aux bornes :
/*
       ------------------
      /                  \
    /                      \
  /                          \  
/           cuts             \
*/



double DYWindow(double index, double indexMax) {
	double temp;
	double Cut=1./16.;
	if(index<(indexMax/16.)) temp=index/indexMax*16.;
	else if((indexMax-index)<(indexMax/16.)) temp=(indexMax-index)/indexMax*16.;
	else temp=1.;
	return temp;
}

