#ifndef  FFTServ_H_SEEN
#define  FFTServ_H_SEEN

#include <complex>
#include "cvector.h"

class FFTServer{
 public:
  FFTServer();
  virtual ~FFTServer();
  virtual void fftf(int l, float* inout);
  virtual void fftb(int l, float* inout);
  virtual void fftf(int l, double* inout);
  virtual void fftb(int l, double* inout);
  virtual void fftf(int l, complex<float>* inout);
  virtual void fftb(int l, complex<float>* inout);
  virtual void fftf(int l, complex<double>* inout);
  virtual void fftb(int l, complex<double>* inout);
  virtual void fftf(Vector& in, Vector& out);
  virtual void fftb(Vector& in, Vector& out);

 protected:
  virtual void checkint_rfft(int l);
  virtual void checkint_dfft(int l);
  virtual void checkint_cfft(int l);
  virtual void checkint_cdfft(int l);

  int sz_rfft;
  float* ws_rfft;

  int sz_cfft;
  float* ws_cfft;

  int sz_dfft;
  double* ws_dfft;

  int sz_cdfft;
  double* ws_cdfft;
};
#endif
