#include "picmapmac.h"
#include <UDebugging.h>

PIColorMapMac::PIColorMapMac(CMapId id)
: PIColorMapGen(id), mPalette(NULL), mCTab(NULL)
{
}

PIColorMapMac::PIColorMapMac(CMapId id, int i)       // Fait une veritable allocation
: PIColorMapGen(id,i)
{
    int n = nCols[id-1];
	mCTab = (CTabHandle) ::NewHandle(sizeof(long) + 
				sizeof(short) + sizeof(short) + 
				256L*sizeof(ColorSpec));
	(**mCTab).ctFlags = 0;
	(**mCTab).ctSeed = GetCTSeed();
	(**mCTab).ctSize = n+2;
    ColorSpec* sp = (**mCTab).ctTable;
    sp[0].rgb.red   = 0;
    sp[0].rgb.green = 0;
    sp[0].rgb.blue  = 0;
    sp[0].value     = 0;
    sp[1].rgb.red   = 65535;
    sp[1].rgb.green = 65535;
    sp[1].rgb.blue  = 65535;
    sp[1].value     = 1;
}


PIColorMapMac::PIColorMapMac(string const& nom, int nCol)
: PIColorMapGen(nom, nCol)
{
	mCTab = (CTabHandle) ::NewHandle(sizeof(long) + 
				sizeof(short) + sizeof(short) + 
				256L*sizeof(ColorSpec));
	(**mCTab).ctFlags = 0;
	(**mCTab).ctSeed = GetCTSeed();
	(**mCTab).ctSize = nCol+2;
    ColorSpec* sp = (**mCTab).ctTable;
    sp[0].rgb.red   = 0;
    sp[0].rgb.green = 0;
    sp[0].rgb.blue  = 0;
    sp[0].value     = 0;
    sp[1].rgb.red   = 65535;
    sp[1].rgb.green = 65535;
    sp[1].rgb.blue  = 65535;
    sp[1].value     = 1;
}

/* --Methode-- */
PIColor PIColorMapMac::GetColor(int n)
{
PIColor picr;
picr.red = picr.green = picr.blue = 0;

if ((n<0) || (n >= NCol()))   
  return(picr);

ColorSpec& sp = (**mCTab).ctTable[n+2];
picr.red   = sp.rgb.red;
picr.green = sp.rgb.green;
picr.blue  = sp.rgb.blue;

return(picr);
}

void PIColorMapMac::AllocColor(PIColor const& col, int index)
{
  ColorSpec& sp = (**mCTab).ctTable[index+2];
  sp.rgb.red   = col.red;
  sp.rgb.green = col.green;
  sp.rgb.blue  = col.blue;
  sp.value     = index+2;
}

void PIColorMapMac::MakeColMap()
{
  PIColorMapGen::MakeColMap();
  mPalette = NewPalette(mNCol,mCTab,pmTolerant,0);
}

void PIColorMapMac::FreeColors()
{
  Assert_(mPalette);
  DisposePalette(mPalette);
  DisposeCTable(mCTab);
}

void PIColorMapMac::CopyFrom(PIColorMapGen* x)
{
  CopyFromGen(x);
  PIColorMapMac* y = (PIColorMapMac*) x;
  mPalette = y->mPalette;
  mCTab = y->mCTab;
  Assert_(mPalette);
}
