#ifndef PDATAARRAY_H
#define PDATAARRAY_H
#include "prefcount.h"

template <class T>
class PDataArray : public PRefCounted {
public:
                            PDataArray(long n, 
                                       bool isTmp=false)
                                                    :PRefCounted(isTmp) 
                                                    {data = new T[n]; sz=n;}
                            ~PDataArray()           {delete[] data;}
  
  T*                        Data()                  {return data;}
  T const*                  Data() const            {return data;}
  long                      Size() const            {return sz;}
  
  // Pointeurs/iterateurs
  T*                        begin()                 {return data;}
  T const*                  begin() const           {return data;}
  T*                        end()                   {return data+sz;}
  T const*                  end() const             {return data+sz;}

  
  PDataArray<T>*            Clone(bool isTmp=false) const;
  
private:
  T*                        data;
  int                       sz;
};


template <class T>
PDataArray<T>* PDataArray<T>::Clone(bool isTmp) const
{
#ifdef TRACE_COPY
  cerr << "PDataArray::Clone" << endl;
#endif
   PDataArray<T>* p = new PDataArray<T>(sz, isTmp);
   memcpy(p->data, data, sz*sizeof(T));
   return p;
}


#endif

