#include <math.h>
#include "unitvector.h"

UnitVector::UnitVector() : Vector3d(1.,0.,0.) 
{
}

UnitVector::UnitVector(double x, double y, double z) : Vector3d(x,y,z) 
{
  this->Normalize();
}

UnitVector::UnitVector(double theta, double phi) : Vector3d(theta,phi) 
{
  this->Normalize();
}

UnitVector::UnitVector(const Vector3d& v) : Vector3d(v) 
{
  this->Normalize();
}

Vector3d& UnitVector::operator=(const Vector3d& v)
{
  Setxyz(v.X(),v.Y(),v.Z());
  this->Normalize();
  return *this;
}

Vector3d& UnitVector::operator+=(const Vector3d& v)
{
  Setxyz(_x+v.X(),_y+v.Y(),_z+v.Z());
  this->Normalize();
  return *this;
}

Vector3d& UnitVector::operator-=(const Vector3d& v)
{
  Setxyz(_x-v.X(),_y-v.Y(),_z-v.Z());
  this->Normalize();
  return *this;
}

Vector3d UnitVector::operator+(const Vector3d& v) const
{
  return UnitVector(_x+v.X(),_y+v.Y(),_z+v.Z());
}

Vector3d UnitVector::operator-(const Vector3d& v) const
{
  return UnitVector(_x-v.X(),_y-v.Y(),_z-v.Z());
}

void UnitVector::Print(ostream& os) const 
{
  os << "UnitVector : (X,Y,Z)= (" << _x << ", " << _y << ", " << _z 
     << ") Theta,Phi= " << _theta << ", " << _phi << "\n"
     << "norme =" << this->Norm() << endl;
}
