#include "machdefs.h"
#include <stdlib.h>
#include <typeinfo>
#include <iostream.h>
#include <string>

#include "nomimagadapter.h"
#include "fitsimage.h"
#include "pimgadapter.h"


//---------------------------------------------------------------
// Class Adaptateur d'objet (Pour NamedObjMgr) d'objet Image<T> 
//---------------------------------------------------------------


/* --Methode-- */
template <class T>
NOMAdapter_Image<T>::NOMAdapter_Image(Image<T> * o)
  : NObjMgrAdapter(o)
{
mImg = o;
}

/* --Methode-- */
template <class T>
NOMAdapter_Image<T>::~NOMAdapter_Image()
{
}

/* --Methode-- */
template <class T>
NObjMgrAdapter* NOMAdapter_Image<T>::Clone(AnyDataObj* o)
{
Image<T>* im = dynamic_cast<Image<T> *>(o);
if (im) return ( new NOMAdapter_Image<T>(im) );
return ( new NObjMgrAdapter(o) );
}

/* --Methode-- */
template <class T>
AnyDataObj* NOMAdapter_Image<T>::GetCopyObj()
{
FitsImage<T> * fima = dynamic_cast<FitsImage<T> *>(mImg);
if (fima == NULL)   return( new Image<T>(*mImg ) );
else return ( new FitsImage<T>(*fima) );
}

/* --Methode-- */
template <class T>
void NOMAdapter_Image<T>::SaveFits(string const & flnm)
{
#ifdef SANS_EVOLPLANCK
FitsImage<T> fim(*mImg, 1);
fim.Save(flnm);
#else
cout << "NOMAdapter_Image<T>::SaveFits() - Error : Not supported for " << s << endl;
#endif
}

/* --Methode-- */
template <class T>
void NOMAdapter_Image<T>::SavePPF(POutPersist& pos, string const & nom)
{
#ifdef SANS_EVOLPLANCK
// PEIDA-EROS L'histo est lui-meme PPersist
string tag = nom;  // A cause de const
mImg->Write(pos,0,tag);
#else
string s = typeid(*mObj).name();
cout << "NOMAdapter_Image<T>::SavePPF() - Error : Not supported for " << s << endl;
#endif
}

/* --Methode-- */
template <class T>
void NOMAdapter_Image<T>::Print(ostream& os)
{
mImg->Print(os);
}


/* --Methode-- */
template <class T>
P2DArrayAdapter* NOMAdapter_Image<T>::Get2DArray(string &)
{
return ( new ImageAdapter<T>(mImg, false) );
}

/* --Methode-- */
template <class T>
NTupleInterface* NOMAdapter_Image<T>::GetNTupleInterface(bool& adel)
{
adel = true;
return( new NTupInt_Image<T>(mImg) );
}



// -------------------------------------------------------------

/* --Methode-- */
template <class T>
NTupInt_Image<T>::NTupInt_Image(Image<T>* m)
{
mImg = m;
}

/* --Methode-- */
template <class T>
NTupInt_Image<T>::~NTupInt_Image()
{
}

/* --Methode-- */
template <class T>
uint_4 NTupInt_Image<T>::NbLines() const 
{
return( mImg->XSize() * mImg->YSize() );
}

/* --Methode-- */
template <class T>
uint_4 NTupInt_Image<T>::NbColumns() const 
{
return(3);
}

/* --Methode-- */
template <class T>
r_8* NTupInt_Image<T>::GetLineD(int n) const 
{
int i,j;
if ((n < 0) || (n >= mImg->XSize() * mImg->YSize() )) 
    for(i=0; i<3; i++)  mRet[i] = 0.;
else { 
  i = n%mImg->XSize();  j = n/mImg->XSize(); 
  mRet[0] = i;  mRet[1] = j;  mRet[2] = (*mImg)(i,j);
  }
return(mRet);
}

/* --Methode-- */
template <class T>
string NTupInt_Image<T>::VarList_C(const char* nx) const 
{
string nomx;
if (nx) nomx = nx;
else nomx = "_xh_";
string vardec = "double x,y,pix,i,j,val; \n";
vardec += "x = i = " + nomx + "[0]; y = j = " + nomx + "[1];  pix = val = " + nomx + "[2]; \n";
return(vardec);
}

#ifdef __CXX_PRAGMA_TEMPLATES__
#pragma define_template NOMAdapter_Image<uint_2>
#pragma define_template NOMAdapter_Image<int_2>
#pragma define_template NOMAdapter_Image<int_4>
#pragma define_template NOMAdapter_Image<r_4>
#pragma define_template NTupInt_Image<uint_2>
#pragma define_template NTupInt_Image<int_2>
#pragma define_template NTupInt_Image<int_4>
#pragma define_template NTupInt_Image<r_4>
#endif
#if defined(__ANSI_TEMPLATES__) || defined(__GNU_TEMPLATES__)
template class NOMAdapter_Image<uint_2>;
template class NOMAdapter_Image<int_2>;
template class NOMAdapter_Image<int_4>;
template class NOMAdapter_Image<r_4>;
template class NTupInt_Image<uint_2>;
template class NTupInt_Image<int_2>;
template class NTupInt_Image<int_4>;
template class NTupInt_Image<r_4>;
#endif


