// This may look like C code, but it is really -*- C++ -*-
// Module PI : Peida Interactive     PIFontMac
// DAPNIA/SPP          E. Aubourg  99

#ifndef PIFONTMAC_H_SEEN
#define PIFONTMAC_H_SEEN

#include "pisysdep.h"
#include "pifontgen.h"


class PIFontMac : public PIFontGen 
{
public :
		PIFontMac(PIFontName fn = PI_DefaultFont);
		PIFontMac(int npt, PIFontName fn = PI_DefaultFont, 
                        PIFontAtt fa = PI_RomanFont);
		PIFontMac(PIFontMac const & fnt);
  virtual	~PIFontMac();

  virtual PIFontMac & operator = (PIFontMac const & fnt);
  virtual bool operator == (PIFontMac const & fnt);

  virtual void		SetFont(PIFontName fn);
  virtual void		SetFontAtt(PIFontAtt fa);
  virtual void		SetFontSz(PIFontSize fs);
  virtual void		SetFontSzPt(int npt);

  virtual PIFontName    GetFontName();
  virtual PIFontAtt     GetFontAtt();
  virtual int		GetFontSize();

  virtual int		GetFontHeight(int& asc, int& desc);
  virtual int		GetStringWidth(char const* s);
  
  virtual void      Apply();

protected:
  void           SelectFont(PIFontName fn, PIFontAtt fa, PIFontSize fs);
  void           SelectFontPt(PIFontName fn, PIFontAtt fa, int npt);

  PIFontName mFName;
  PIFontAtt  mFAtt;
  int        mFSize;
  short      mFNum;
  int        mFStyle;
};

typedef PIFontMac PIFont;

#endif      // PIFONTMAC_H_SEEN
