#ifndef PIMENUMAC_H_SEEN
#define PIMENUMAC_H_SEEN

#include "pimenugen.h"
#include <LMenu.h>
#include <vector>
#include <list>

// Menu general
class PIMenuMac : public PIMenuGen {
public:
					PIMenuMac(PIWdg* par, const char* nom, PIMenuType pdpu=k_UTMenu);
				   ~PIMenuMac();
				   
  virtual void	  AppendItem(const char* nom, PIMessage msg, char* sc=NULL);
  virtual void	  AppendCheckItem(const char* nom, PIMessage msg, char* sc=NULL);
  virtual void	  AppendPDMenu(PIMenuGen *pdm, char* sc=NULL);

  virtual void    DeleteItem(const char *nom);
  virtual void    DeleteItemMsg(PIMessage msg);
  virtual void    DeleteItemNum(int n);

  virtual void    SetSensitivity(const char *nom, bool sens=true); 
  virtual void    SetSensitivityMsg(PIMessage msg, bool sens=true); 
  virtual void    SetSensitivityNum(int n, bool sens=true);

  virtual bool    IsSensitive(const char *nom);
  virtual bool    IsSensitiveMsg(PIMessage msg);
  virtual bool    IsSensitiveNum(int n);

  virtual void    SetState(const char *nom, bool st=false); 
  virtual void    SetStateMsg(PIMessage msg, bool st=false); 
  virtual void    SetStateNum(int n, bool st=false);
 
  virtual bool    GetState(const char *nom); 
  virtual bool    GetStateMsg(PIMessage msg); 
  virtual bool    GetStateNum(int n); 

  virtual void    Show();
  virtual void    Show(PIWdg *w, int px, int py);

  LMenu*          GetPPMenu() {return macMenu;}
  void            ItemSelected(int item);
  string          GetMenuItemText(int item);
  PIMessage       GetMenuItemMsg(int item);	
protected:
	LMenu*          macMenu;
	struct menuInfo {
	  short      mId;
	  PIMenuMac* pimenu;
	};
	struct itemInfo {
	  PIMessage  pimsg;
	  string     name;
	};
	static vector<menuInfo> mMenuInfos;
	vector<itemInfo> mItemInfos;
	static int      lastId;
	
	friend class    PIMenubarMac;
	friend class    PIOptMenuMac;
	friend class    PIPPOptMenu;
	friend class    PIPPMenuBar;
	MenuHandle      GetMacMenuHandle();
	ResIDT          GetMacMenuID();
	
    int             GetItemNum(const char* nom);
	int             GetItemNumMsg(PIMessage msg);
	int             GetMenuNum();
	static int      GetMenuNum(short menuId);
	static PIMenuMac*  GetMenu(short menuId);
    void            AddItem(const char* nom, PIMessage msg, int tog, char* sc, PIMenuMac *pdm);
};


typedef PIMenuMac      PIMenu;

#endif
