#include "pippmenubar.h"

PIPPMenuBar::PIPPMenuBar()
: LMenuBar(MBAR_Initial)
{

}

PIPPMenuBar::~PIPPMenuBar()
{}

CommandT
PIPPMenuBar::MenuCommandSelection(
	const EventRecord	&inMouseEvent,
	Int32				&outMenuChoice) const
{
	outMenuChoice = ::MenuSelect(inMouseEvent.where);
	
	int menuId = HiWord(outMenuChoice);
	int menuItem = LoWord(outMenuChoice)-1; // Dans PI les menu items commencent a 0
	
	PIMenuMac* menu = PIMenuMac::GetMenu(menuId);
	if (menu)
	  menu->ItemSelected(menuItem);
	
	return cmd_Nothing;
}

CommandT
PIPPMenuBar::FindKeyCommand(
	const EventRecord	&inKeyEvent,
	Int32				&outMenuChoice) const
{
	char	theChar = inKeyEvent.message & charCodeMask;
	outMenuChoice = ::MenuKey(theChar);
	int menuId = HiWord(outMenuChoice);
	int menuItem = LoWord(outMenuChoice)-1; // Dans PI les menu items commencent a 0
	
	PIMenuMac* menu = PIMenuMac::GetMenu(menuId);
	if (menu)
	  menu->ItemSelected(menuItem);
	
	return cmd_Nothing;
}
