#ifndef PINTUPLE3D_H
#define PINTUPLE3D_H

#include "ntupintf.h"
#include "pi3ddrw.h"

class PINTuple3D : public PIDrawer3D {
public:
                     PINTuple3D(NTupleInterface* nt, bool ad=false);
  virtual           ~PINTuple3D();
  
  virtual void       Draw(PIGraphicUC* g, double xmin, double ymin, double xmax, double ymax);
  virtual void       UpdateLimits();
  
          void       SelectXYZ(const char* px, const char* py, const char* pz);
          void       SelectErrBar(const char* erbx=NULL, const char* erby=NULL, const char* erbz=NULL);

       
protected:
  NTupleInterface* mNT;
  bool mAdDO;
  int xK, yK, zK;           // Index du nom de variable en X/Y/Z ds le ntuple
  int xebK, yebK, zebK;     // Index du nom de variable en ErrBarX/Y/Z ds le ntuple

};

#endif




