#ifndef PIMENUMAC_H_SEEN
#define PIMENUMAC_H_SEEN

#include "pimenugen.h"
#include <LMenu.h>
#include <vector.h>
#include <list.h>

// Menu general
class PIMenuMac : public PIMenuGen {
public:
					PIMenuMac(PIMsgHandler* par, char* nom, PIMenuType pdpu);
				   ~PIMenuMac();
				   
    virtual void    AppendItem(char* nom, PIMessage msg, char* sc=NULL);

    virtual void    DeleteItem(char *nom);
    virtual void    DeleteItemMsg(PIMessage msg);
    virtual void    DeleteItemNum(int n);

    virtual void    CheckItem(char *nom, bool st=false); 
    virtual void    CheckItemMsg(PIMessage msg, bool st=false); 
    virtual void    CheckItemNum(int n, bool st=false); 
	
    virtual void    Show();
    virtual void    Show(PIWdg *w, int px, int py);

    virtual void    Hide();
    
    int             MenuId() {return mMenuId;}
    void            ItemSelected(int item);
    
	string          GetMenuItemText(int item);
	int             GetMenuItemMsg(int item);
	int             FindItemByMsg(PIMessage msg);
	int             FindItemByName(string const& nom);
	
protected:
	static PIMenuMac* findMenu(int id);
	LMenu*          macMenu;
	int             mMenuId;
	vector<PIMessage>    mMsgs;
	static int      lastId;
	static list<PIMenuMac*> sMenus;
	
	friend class    PIMenubarMac;
	friend class    PIOptMenuMac;
	friend class    PIPPMenuBar;
	MenuHandle      GetMacMenuHandle();
	ResIDT          GetMacMenuID();
	
   
};

// Menu popup
class PIPUMenuMac : public PIMenuMac
{
public:
               PIPUMenuMac(PIMsgHandler* par, char* nom);
               ~PIPUMenuMac();
virtual void   Show();
};

// Menu pull-down
class PIPDMenuMac : public PIMenuMac
{
public:
               PIPDMenuMac(PIMsgHandler* par, char* nom);
               ~PIPDMenuMac();
};


typedef PIMenuMac      PIMenu;
typedef PIPUMenuMac    PIPUMenu;
typedef PIPDMenuMac    PIPDMenu;

#endif
