#ifndef SPHERETHETAPHI_SEEN
#define SPHERETHETAPHI_SEEN

#include "sphericalmap.h"
#include "ndatablock.h"
#include "tvector.h"

#include "anydataobj.h"
#include "ppersist.h"

// ***************** Class SphereThetaPhi *****************************

template <class T>
class SphereThetaPhi : public SphericalMap<T>, public AnyDataObj
{

public :

SphereThetaPhi();
SphereThetaPhi(int_4 m);
SphereThetaPhi(char* flnm);
SphereThetaPhi(const SphereThetaPhi<T>& s);
virtual ~SphereThetaPhi();

// ------------ Definition of PixelMap abstract methods -

/* retourne/fixe le nombre de pixels */ 
virtual int_4 NbPixels() const;
inline void setNbPixels(int_4 nbpix) { NPix_= nbpix; }

/* retourne la valeur du pixel d'indice k */ 
virtual T&       PixVal(int_4 k);
virtual T const& PixVal(int_4 k) const;

/* retourne l'indice du pixel a (theta,phi) */ 
virtual int_4 PixIndexSph(float theta, float phi) const;

/* retourne les coordonnees Spheriques du centre du pixel d'indice k */ 
virtual void PixThetaPhi(int_4 k, float& theta, float& phi) const;

/* retourne/fixe l'angle Solide de Pixel   (steradians) */ 
virtual r_8 PixSolAngle(int_4 dummy) const;
inline void setPixSolAngle(r_8 omega) { Omega_= omega; }
 
/* retourne/fixe la valeur du parametre de decoupage m */ 
inline virtual int_4 SizeIndex() const { return( NTheta_); }
inline void setSizeIndex(int_4 nbindex) { NTheta_= nbindex; }

// ------------- Specific methods  ----------------------

virtual void Resize(int_4 m);

inline virtual char* TypeOfMap() const {return "TETAFI";};

/* Valeurs de theta des paralleles et phi des meridiens limitant  le pixel d'indice k */
virtual void Limits(int_4 k,float& tet1,float& tet2,float& phi1,float& phi2);

/* Nombre de tranches en theta */ 
int_4 NbThetaSlices() const;

/* Nombre de pixels en phi de la tranche d'indice kt */ 
int_4 NPhi(int_4 kt) const;

/* Renvoie dans t1,t2 les valeurs respectives de theta min et theta max  */
/* de la tranche d'indice kt  */ 
void Theta(int_4 kt, float& t1, float& t2);

/* Renvoie dans p1,p2 les valeurs phimin et phimax du pixel d'indice jp  */
/* dans la tranche d'indice kt  */ 
void Phi(int_4 kt, int_4 jp, float& p1, float& p2);

/* Renvoie l'indice k du pixel d'indice jp dans la tranche d'indice kt   */
int_4 Index(int_4 kt, int_4 jp) const;

/* Indice kt de la tranche et indice jp du pixel d'indice k  */ 
void ThetaPhiIndex(int_4 k,int_4& kt,int_4& jp);

void Pixelize(int_4); 

void GetThetaSlice(int_4 index,r_4& theta,TVector<float>& phi,TVector<T>& value) const; 

/*retourne le tableau contenant le nombre de pixels en phi de chacune des bandes en theta */
inline const int_4* getmNPhi() const { return(NPhi_); }
void setmNPhi(int_4* array, int_4 m);

/* retourne/remplit le tableau contenant le nombre/Deuxpi total des pixels contenus dans les bandes */
inline const int_4* getmTNphi() const { return(TNphi_); }
void setmTNphi(int_4* array, int_4 m);

/* retourne/remplit le tableau contenant les valeurs limites de theta */
inline const r_4* getmTheta() const { return(Theta_); }
void setmTheta(r_4* array, int_4 m);

/* retourne le pointeur vers/remplit  le vecteur des contenus des pixels */ 
inline const NDataBlock<T>* getDataBlock() const { return (&pixels_); }
void setDataBlock(T* data, int_4 m);

/* impression */ 
void print(ostream& os) const;

private :

// ------------- mthodes internes ----------------------          
void InitNul();
void Clear();

// ------------- variables internes ---------------------
int_4 NTheta_;
int_4 NPix_;
r_8 Omega_;
int_4* NPhi_;
int_4* TNphi_;
r_4* Theta_;
NDataBlock<T> pixels_;
};

// ------------- Classe pour la gestion de persistance --
template <class T>
class FIO_SphereThetaPhi : public PPersist  
{
public:

FIO_SphereThetaPhi();
FIO_SphereThetaPhi(string const & filename); 
FIO_SphereThetaPhi(const SphereThetaPhi<T>& obj);
FIO_SphereThetaPhi(SphereThetaPhi<T>* obj);
virtual ~FIO_SphereThetaPhi();
virtual AnyDataObj* DataObj();
inline operator SphereThetaPhi<T>() { return(*dobj); }
inline SphereThetaPhi<T> getObj() { return(*dobj); }

protected :

virtual void ReadSelf(PInPersist&);           
virtual void WriteSelf(POutPersist&) const;  
SphereThetaPhi<T>* dobj;
bool ownobj;
};

#endif
