#ifndef PIXELMAP_SEEN
#define PIXELMAP_SEEN

#include "ppersist.h" 
#include "dvlist.h"
#include <iostream.h>

// General map of pixels on part of sphere or whole sphere
// Class hierarchy :
//   PixelMap
//      SphericalMap
//         SphereThetaPhi
//         SphereGorski
//         SphereIco
//      LocalMap

template<class T>
class PixelMap  
{

public:
  
PixelMap():mInfo_(NULL) {};
virtual ~PixelMap() {};
  
// Number of pixels
virtual int_4 NbPixels() const=0;
   
// Value of pixel number k
virtual T& PixVal(int_4 k)=0;
virtual T const& PixVal(int_4 k) const=0;
   
// Index of pixel at (theta,phi)
virtual int_4 PixIndexSph(float theta, float phi) const=0;

// Value of pixel number at (theta,phi)
virtual T& PixValSph(float theta, float phi)
                           {return PixVal(PixIndexSph(theta,phi));}
virtual T const& PixValSph(float theta, float phi) const
                           {return PixVal(PixIndexSph(theta,phi));}

// Spherical coordinates of center of pixel number k
virtual void PixThetaPhi(int_4 k, float& theta, float& phi) const=0;

// provides a integer characterizing the pixelization refinement 
// (depending of the type of the map)              
virtual int_4 SizeIndex() const=0;
virtual char* TypeOfMap() const =0;

// Pixel  (steradians)
virtual r_8 PixSolAngle(int_4 k) const =0; 

// Overloading of () to access pixel number k.
inline T& operator()(int_4 k) {return(PixVal(k));}
inline T const& operator()(int_4 k) const {return(PixVal(k));}

// Note : no overloading of (float,float) to access pixel (theta,phi).
// overloading of (float,float) in SphericalMap
// overloading of (int,int)     in CartesianMap

//++
DVList& Info()
//
// Renvoie une reference sur l''objet DVList Associe
//--
  {
    if (mInfo_ == NULL)  mInfo_ = new DVList;
    return(*mInfo_);
  }

const DVList*  ptrInfo() const
  {
    return mInfo_;
  }

protected :

    DVList* mInfo_;        // Infos (variables) attachees 
};
#endif
