#ifndef FITSIOSERVER_SEEN
#define FITSIOSERVER_SEEN

#include "fitsio.h" 
#include "tvector.h"
#include "sphericalmap.h"
#include "localmap.h"
#include "dvlist.h"

class FitsIoServer 
{
public :
FitsIoServer() : FITS_tab_typ_(0), itab_(NULL), ftab_(NULL), dtab_(NULL) {;}
~FitsIoServer()
  {
    if (itab_ != NULL) delete [] itab_;
    if (ftab_ != NULL) delete [] ftab_;
    if (dtab_ != NULL) delete [] dtab_;
  }
void load(SphericalMap<double>& sph, char flnm[]);
void load(SphericalMap<float>& sph, char flnm[]);
void load(TMatrix<double>& mat, char flnm[]);
void load(LocalMap<double>& sph, char flnm[]);
void save(SphericalMap<double>& sph, char flnm[]);
void save(SphericalMap<float>& sph, char flnm[]);
void save(LocalMap<double>& locm, char flnm[]);
void save(TMatrix<double>& mat, char flnm[]);
void sinus_picture_projection(SphericalMap<double>& sph, char flnm[]);
void sinus_picture_projection(SphericalMap<float>& sph, char flnm[]);
void picture(LocalMap<double>& lcm, char flnm[]);
private :
void read_sphere(char flnm[], int& npixels, int& nside);
void planck_write_img( fitsfile *fptr, int naxis,int n1, int n2, int n3, DVList& dvl);
void planck_read_img( fitsfile *fptr, long& naxis,int& n1, int& n2, int& n3, DVList& dvl);
void  write_picture(long* naxes, float* map,  char* filename) const;

void printerror(int status) const;
inline int key_type_PL2FITS(char typ) 
  {
  switch (typ) 
    {
    case 'I' :
      return TINT;
    case 'D' : 
      return TDOUBLE;
    case 'S' : 
      return TSTRING;
    default :
      cout << " FITSIOSERVER : type de donnee non prevu " << endl;
      return 0;
    }
    
  }
int FITS_tab_typ_;
int* itab_;
float* ftab_;
double* dtab_;
};
#endif

 

