#  -*- makefile -*-
# ######################### PEIDA++ ############################# 
# ##### LAL (Orsay) / IN2P3-CNRS  DAPNIA/SPP (Saclay) / CEA #####
# ############################################################### 
# General setup GNU Makefile for EROS. To be included in all makefiles.  
# Define  makefile variables according to CPU 
# MACHEROSD = `uname | sed 's/-//'`   i.e. { AIX HPUX OSF1 Linux ... }
# and compilers {g++, cxx, KCC, xlC, aCC, ...}
# 
# Makefile variables set are:
# - Path to Exec, Include, Libs, Obj directories (from DPCDEVREP env. var.)
#     i.e. variables LIB, OBJ, EXE, INC 
#---------------------------------------------------------------------------

# define MACHEROS from uname
MACHEROS := $(shell echo `uname`)
# define the -D option
MACHEROSD := $(shell echo `uname | sed 's/-//'`)
# Le sous-repertoire des objets specifique machine-compilo
#   OSF1 : Alpha avec gcc
#   OSF1-cxx : Alpha avec cxx

#### C++
ifdef EROSCXX
  CXX := $(EROSCXX)
endif

ifeq ($(CXX),gcc)
  override CXX := g++
endif

ifeq ($(EROSCXX),egcs++)
  # en fait de compilo de egcs++ s'appelle g++ !
  # comme il faut bien differentier ln -s /usr/bin/g++ /usr/bin/egcs++
  override CXX := egcs++
endif

ifeq ($(CC),xlC)
  override CXX := xlC
endif

#### C
ifeq ($(CXX), xlC)
  override CC := xlC
endif

ifeq ($(CXX), g++)
  CC := gcc
endif

ifeq ($(EROSCXX), egcs++)
  CC := egcs
endif

#### Fortran (tout ce qui est lie au Fortran est defini ici #############
FC = f77
ifeq ($(SITE),CCIN2P3)
  ifeq ($(MACHEROS),AIX)
    override FC := xlf
  endif
endif
ifeq (${MACHEROS},Linux)
#  override FC := f77
  override FC := g77
endif

ifeq (${MACHEROS},OSF1)
  LIBFORT = -lfor -lFutil -lots -lUfor
endif
ifeq (${MACHEROS},Linux)
  LIBFORT = -lf2c
endif
#########################################################################


MACHDIR := $(MACHEROS)-$(CXX)


#-
#-   Define Makefile paths
#-  (NE PAS TOUCHER CES LIGNES: generation automatique de MakefileUser.h)
#-  
PP  := ${DPCBASEREP}/${MACHDIR}/
PPH := ${HOME}/${MACHDIR}/
LIB := ${PP}/Libs/
SLB := ${PP}/ShLibs/
OBJ := ${PPH}/Objs/
EXE := ${PPH}/Exec/
INC := ${DPCBASEREP}/Include/
CCI := ${INC}/CInc/
GLB := ${GNU}/${MACHEROS}/lib/
#--

#-   Flag for optimisation/ debug
# Pour forcer sans debug, DBGFLAG = -g0
ifndef OPTFLAG
  OPTFLAG  := -O
endif

ifndef DBGFLAG
  DBGFLAG  := -g
endif

# DBGFLAG a -g0 veut dire pas de debug. Tout le monde a ca par defaut...
ifeq ($(DBGFLAG), -g0)
  override DBGFLAG :=
endif

# xlC ne connait pas -O0, par defaut il n'optimise pas.
ifeq ($(OPTFLAG), -O0)
  ifeq ($(CC), xlC)
    override OPTFLAG :=
  endif
endif

AR       := ar
ARFLAGS  := -rcs

# le gnu ar ne fonctionne pas bien sur OSF...
ifeq (${MACHEROS},OSF1)
AR       := /usr/bin/ar
endif
# et sur AIX il nous sort des tas de warnings inutiles
ifeq ($(MACHEROS),AIX)
AR := /usr/bin/ar
endif

#   Avec certains compilateurs C++ (KCC, aCC) , il faut fabriquer les librairies et 
# les shared libs avec la meme commande 
override ARCXX := 
ifeq ($(CXX),KCC)
ARCXX  := KCC
endif
ifeq ($(CXX),aCC)
ARCXX  := aCC
endif

# Les chemins speciaux pour includes systemes et bibliotheques
ifeq (${MACHEROS},HP-UX)
  XLDLIBS := -L.
  XCFLAGS := -I.
endif


#  Pour compiler PI, sous Linux, les includes et libs se trouve souvent ds /usr/X11/include /usr/X11/lib/
ifeq (${MACHEROS},Linux)
  XLDLIBS := -L/usr/X11/lib 
  XCFLAGS := -I/usr/X11/include
  LDLIBS := -ldl
endif

# Pour RFIO
ifeq ($(SITE),CCIN2P3)
  XCFLAGS := $(XCFLAGS) -D RFIO -I/usr/local/include/shift
  XLDLIBS := $(XLDLIBS) -L/usr/local/lib -lshift
endif

# Les bibliotheques gnu C pour le fort du CCPN
ifeq ($(SITE),CCIN2P3)
 ifeq ($(CC), gcc)
  ifeq ($(MACHEROS),HP-UX)
     FGLIB := -L/usr/local/lib/gcc-lib/hppa1.1-hp-hpux9.05/2.7.2.1 -lgcc
  endif
  ifeq ($(MACHEROS),AIX)
     FGLIB := -L/usr/local/lib/gcc-lib/rs6000-ibm-aix3.2.5/2.7.2.1 -lgcc
  endif
 endif
endif

# Chemin pour la librairie cfitsio 
FITSIOREP :=
FITSIOLIB :=
ifeq ($(SITE),LAL)
  override FITSIOREP :=/exp/planck/FitsIO/cfitsio/ 
  override FITSIOLIB := -L$(FITSIOREP) -lcfitsio
endif

#  S'il y a des flags particulier pour un module de compilation
#ifndef MODULECPPFLAGS
  override MODULECPPFLAGS :=
#endif

CPPFLAGS     :=  -I${INC} -I$(FITSIOREP) -D${MACHEROSD} -I$(INC)/tnt $(MODULECPPFLAGS)

# Les options selon les divers compilateurs
# GNU
ifeq ($(CC), gcc)
  CFLAGS       := -Wall -Wpointer-arith \
                  -Wmissing-prototypes -Wsynth -I$(INC) $(XCFLAGS) \
                  $(OPTFLAG) $(DBGFLAG) $(MYCFLAGS)
  LDLIBS       := $(LDLIBS) $(XLDLIBS)
endif
ifeq ($(CC), egcs)
  CFLAGS       := -Wall -Wpointer-arith \
                  -Wmissing-prototypes -Wsynth -I$(INC) $(XCFLAGS) \
                  $(OPTFLAG) $(DBGFLAG) $(MYCFLAGS)
  LDLIBS       := $(LDLIBS) $(XLDLIBS)
endif

ifeq ($(CXX), g++)
  CXXFLAGS       := -Wall -Wpointer-arith \
                    -Wmissing-prototypes -Wsynth -I$(INC) $(XCFLAGS) \
                    $(OPTFLAG) $(DBGFLAG) $(MYCFLAGS) 
  LDLIBS      := $(LDLIBS) $(XLDLIBS)
#  Il faut trouver un moyen d'automatiser ca $CHECK$  Reza 23/12/98
  ifdef GCCV28
    CXXFLAGS := $(CXXFLAGS) -fguiding-decls -fname-mangling-version-1 -DCOMPILER_EXCEPTIONS
  endif
  ifdef NOSHLIB 
    LDFLAGS := -static
  endif
endif
ifeq ($(CXX), egcs++)
  CXXFLAGS       := -Wall -Wpointer-arith \
                    -Wmissing-prototypes -Wsynth -I$(INC) $(XCFLAGS) \
                    $(OPTFLAG) $(DBGFLAG) $(MYCFLAGS) 
  LDLIBS      := $(LDLIBS) $(XLDLIBS)
  ifdef NOSHLIB 
    LDFLAGS := -static
  endif
endif

# Compilateur C natif HP-UX
ifeq (${MACHEROS},HP-UX)
ifeq ($(CC),cc)                                    
  CFLAGS       :=  +Z -Aa -Ae $(XCFLAGS) $(OPTFLAG) $(DBGFLAG) $(MYCFLAGS) 
  FFLAGS       :=  -Aa -I${INC}   -D${MACHEROSD}  
  CPPFLAGS     :=  -I${INC}  -I$(INC)/tnt -D${MACHEROSD} \
               -D_HPUX_SOURCE $(MODULECPPFLAGS)
  LDLIBS      := $(XLDLIBS)
  override NOSHLIB := Y

endif
ifeq ($(CXX),aCC)
  CXXFLAGS := $(XCFLAGS) $(OPTFLAG) $(DBGFLAG) $(MYCFLAGS) +Z -D__aCC__
#  -DCOMPILER_EXCEPTIONS -D__ANSI_TEMPLATES__  definis ds defs.h
endif
endif

# AIX, xlC comme compilateur C et C++
ifeq ($(CXX), xlC)
  CFLAGS := $(OPTFLAG) $(DBGFLAG) $(MYCFLAGS) $(XCFLAGS)
  CPPFLAGS := -I$(INC)/Syst -I${INC}  -I$(INC)/tnt -D${MACHEROSD} $(MODULECPPFLAGS)
  CXXFLAGS     := $(CFLAGS) -D__xlC -DCOMPILER_EXCEPTIONS
# -DCOMPILER_EXCEPTIONS defini ds defs.h
  LDLIBS      := $(XLDLIBS)

# Pour faire des bibliotheques partagees, il faut faire un truc du
# style 
#ld -o shrsub.o subs1.o subs2.o -bE:shrsub.exp -bM:SRE -lc

# Pour le moment on ne se fatigue pas, tant pis
  override NOSHLIB := Y

# Et puis 1540-293: (W) est un FAUX warning, on supprime les warnings
  CXXFLAGS := -qflag=e $(CXXFLAGS)
endif

#gcc sur Solaris
ifeq ($(MACHEROS),SunOS)
 override NOSHLIB := Y
endif

ifeq ($(CXX), cxx)
  ifeq ($(DBGFLAG), -g)
    ifdef OPTFLAG
      override DBGFLAG := -g1
    endif
#    ifdef XOPT
#      override DBGFLAG := -g1
#    endif
  endif

# chemin pour repository CXX
 REP := $(OBJ)/cxxrep/
 REPPI := $(OBJ)/cxxrep_PI/
 REPCXX := -ptr $(OBJ)/cxxrep/
 ifdef MODULECXXREPNAME
   REPCXX := -ptr $(OBJ)/cxxrep_$(MODULECXXREPNAME)/  -ptr $(OBJ)/cxxrep/
   REPM := $(OBJ)/cxxrep_$(MODULECXXREPNAME)/
 endif

  LDLIBS      := $(XLDLIBS) -lrt

  CXXFLAGS := $(OPTFLAG) $(DBGFLAG) $(MYCFLAGS) -DCOMPILER_EXCEPTIONS  \
              $(REPCXX) -no_implicit_include 
  CFLAGS := $(OPTFLAG) $(DBGFLAG) $(MYCFLAGS)
#  CXXFLAGS := $(OPTFLAG) $(DBGFLAG) $(MYCFLAGS) -DCOMPILER_EXCEPTIONS \
#	      -nopt -define_templates
  ifeq ($(XOPT), 1)
    override DBGFLAG :=
    CXXFLAGS := $(DBGFLAG) $(MYCFLAGS) -DCOMPILER_EXCEPTIONS \
	        $(REPCXX) -fp_reorder \
	        -O5 -inline speed -tune host
  endif
  ifeq ($(XOPT), 2)
    override DBGFLAG :=
    CXXFLAGS := $(DBGFLAG) $(MYCFLAGS) -DCOMPILER_EXCEPTIONS \
	      $(REPCXX) -fp_reorder \
	      -O5 -inline speed -tune host \
	      -assume trusted_short_alignment
  endif
  ifeq ($(XOPT), 3)
    override DBGFLAG :=
    CXXFLAGS := $(DBGFLAG) $(MYCFLAGS) -DCOMPILER_EXCEPTIONS \
	      $(REPCXX) -fp_reorder \
	      -O5 -inline speed -tune host \
	      -assume trusted_short_alignment \
	      -non_shared -om
    override NOSHLIB := Y
  endif

# le fichier X11/Xlib.h contient des declarations de fonctions sans type
# Cela genere un grand nombre de warning avec cxx V6
# La variable MODULEDECCXXFLAGS permet de specifier des options de compilation 
# pour un module donne  
  ifdef MODULEDECCXXFLAGS
    CXXFLAGS := $(CXXFLAGS) $(MODULEDECCXXFLAGS)
  endif
endif
ifeq ($(CC),cc)
  ifeq ($(MACHEROS),OSF1)
  ifeq ($(XOPT), 1)
    CFLAGS :=  $(DBGFLAG) $(MYCFLAGS) -fp_reorder \
	      -O4 -inline speed -tune host
  endif
  ifeq ($(XOPT), 2)
    CFLAGS :=  $(DBGFLAG) $(MYCFLAGS) -fp_reorder \
	      -O4 -inline speed -tune host \
	      -assume trusted_short_alignment -fast
  endif
  ifeq ($(XOPT), 3)
    CFLAGS :=  $(DBGFLAG) $(MYCFLAGS) -fp_reorder \
	      -O4 -inline speed -tune host \
	      -assume trusted_short_alignment -fast \
	      -non_shared -om
  endif
  endif
endif


#  Compilateur KAI 
ifeq ($(CXX), KCC)
  CXXFLAGS     :=  --exceptions --rtti  --auto_instantiation --one_instantiation_per_object -D__KCC__
# Flag --one_instantiation_per_object mis - Reza 02/03/99
# -DCOMPILER_EXCEPTIONS -D__ANSI_TEMPLATES__  definis ds defs.h 
endif

# Autres compilateurs natifs.

#  CFLAGS       :=  -I$(INC) $(XCFLAGS) $(OPTFLAG) $(DBGFLAG) $(MYCFLAGS)
#  CXXFLAGS     := $(CFLAGS)
#  LDLIBS      := $(XLDLIBS)

#- redefine implicit rule. Les .o sont dans $(OBJ).
$(OBJ)%.o:%.c
	$(COMPILE.c) -o $@ $<

$(OBJ)%.o:%.cc
	$(COMPILE.cc) -o $@ $<

$(OBJ)%.o:%.f
	$(COMPILE.f) -o $@ $< 

#OSF1
#LDFC est f77
#LDFCFLAGS est rien

#parfois
#LDFC est cc
#LDFCFLAGS est -ltruc

#------------------------------------------------- End of Makefile.h ------- 
# fin gene auto MakefileUser.h
