#include "picmapgen.h"
#include <list>
#include <algorithm>
#include "pisysdep.h"
#include PICMAPNTV_H
#include PICMAP_H



PIColorMapGen* PIColorMapGen::maps[4] = {NULL,NULL,NULL,NULL};

int PIColorMapGen::nCols[6] = {32,32,32,32,32,16};
char* PIColorMapGen::noms[6] = {"Grey32","InvGrey32","ColRJ32","ColBR32","ColRV32","Col16"};

PIColorMapGen::PIColorMapGen(CMapId)
{
}

void PIColorMapGen::CopyFromGen(PIColorMapGen* m)
{
  mNom = m->mNom;
  mNCol = m->mNCol;
  mType = m->mType;
}


PIColorMapGen::PIColorMapGen(string const& nom, int nCol)
{
  mNom = nom;
  mNCol = nCol;
  mType = CMAP_OTHER;
}

PIColorMapGen::PIColorMapGen(CMapId id, int)
{
  if (id < CMAP_GREY32 && id > CMAP_COL16)
     id = CMAP_GREY32; // BEUARK
  mNom = noms[id - 1];
  mNCol = nCols[id - 1];
  mType = id;
}


PIColorMapGen::~PIColorMapGen()
{
}

/*  Definition d' une table de couleurs  R G B   */

static float R_RGB1[16] =
{0.0,0.00,0.0,0.0,0.0,0.00,0.0,0.6,0.8,1.0,1.00,1.0,0.75,1.0,0.85,1.0};
static float G_RGB1[16] =
{0.0,0.00,0.0,0.8,1.0,1.00,1.0,0.8,0.8,1.0,0.75,0.6,0.00,0.0,0.0,0.0};
static float B_RGB1[16] =
{0.0,0.75,1.0,1.0,1.0,0.75,0.0,0.0,0.0,0.0,0.00,0.5,0.75,1.0,0.0,0.0};



void PIColorMapGen::MakeColMap()
{
  PIColor mycol;
  
  switch (mType)
  {
  case CMAP_GREY32 :
    {for(int i=0; i<mNCol; i++)
      {
      mycol.red = mycol.green = mycol.blue = 3535+(i*62000/32);
      AllocColor(mycol, i);
      }
    break;
    }
  case CMAP_GREYINV32 :
    {for(int i=0; i<mNCol; i++)
      {
      mycol.red = mycol.green = mycol.blue = 65535-(i*62000/32);
      AllocColor(mycol, i);
      }
    break;
    }
  case CMAP_COL16 :
    {for(int i=0; i<mNCol; i++)
      {
      mycol.red = (int)(R_RGB1[i]*65535.);
      mycol.green = (int)(G_RGB1[i]*65535.);
      mycol.blue =(int)(B_RGB1[i]*65535.) ;
      AllocColor(mycol, i);
      }
    break;
    }
  case CMAP_COLRJ32 :
    {for(int i=0; i<mNCol; i++)
      {
      if (i < 12) 
        { mycol.green = mycol.blue = 0;  
          mycol.red = 21535+(i*4000); }
      else if (i < 24)
        { mycol.blue = 0;   mycol.red = 65535;
          mycol.green = 21535+(i-12)*4000;  }
      else 
        { mycol.green = mycol.red = 65535;
          mycol.blue = 17535+(i-23)*6000; }

      AllocColor(mycol, i);
      }
    break;
    }
  case CMAP_COLBR32 :
    {for(int i=0; i<mNCol; i++)
      {
      if (i < 5) 
        { mycol.green = mycol.red = 0;  
          mycol.blue = 5535+i*15000; }
      else if (i < 10)
        { mycol.blue = 65535;
          mycol.green = 5535+(i-5)*9000;
          mycol.red = 0;  }
      else if (i < 15)
        { mycol.blue = 60000-(i-10)*15000;
          mycol.green = 41535+(i-10)*6000;
          mycol.red = 0;  }
      else if (i < 21)
        { mycol.blue = 0;
          mycol.green = 65535;
          mycol.red = 5535+(i-15)*12000;  }
      else if (i < 27)
        { mycol.blue = 0;
          mycol.green = 60000-(i-21)*12000;
          mycol.red = 65535-(i-21)*2000;  }
      else 
        { mycol.blue = 0;
          mycol.green = 0;
          mycol.red = 57535+(i-27)*2000; }

      AllocColor(mycol, i);
      }
    break;
    }
  case CMAP_COLRV32 :
    {for(int i=0; i<mNCol; i++)
      {
      if (i < 8) 
        { mycol.green = 15000+(i*5000); mycol.blue = 0;  
          mycol.red = 15000+(i*5000); }
      else if (i < 21)
        { mycol.green = 50000-(i-7)*5000;   
          if (mycol.green < 0)  mycol.green = 0;
          mycol.blue = 0;
          mycol.red = 53535+(i-8)*1000;  }
      else 
        { mycol.green = 0;  mycol.red = 65535;
          mycol.blue = 15535+(i-21)*5000; }

      AllocColor(mycol, i);
      }
    break;
    }
  default :
    {for(int i=0; i<mNCol; i++)
      {
         mycol.green = mycol.red = mycol.blue = 0;
         AllocColor(mycol, i);
      }
    break;
    }
  }
}


