#ifndef PINTUPLE3D_H
#define PINTUPLE3D_H

#include "ntupintf.h"
#include "pi3ddrw.h"

class PINTuple3D : public PIDrawer3D {
public:
                     PINTuple3D(NTupleInterface* nt, bool ad=false);
  virtual           ~PINTuple3D();
  
  virtual void       Draw(PIGraphicUC* g, double xmin, double ymin, double xmax, double ymax);
  virtual void       UpdateLimits();
  
  virtual void       SelectXYZ(const char* px, const char* py, const char* pz);
  virtual void       SelectWt(const char* pw=NULL, int nbins=10);
  virtual void       SelectErrBar(const char* erbx=NULL, const char* erby=NULL, const char* erbz=NULL);
  virtual void       SelectLabel(const char* plabel);

       
protected:
  NTupleInterface* mNT;
  bool mAdDO;
  int xK, yK, zK;           // Index du nom de variable en X/Y/Z ds le ntuple
  int xebK, yebK, zebK;     // Index du nom de variable en ErrBarX/Y/Z ds le ntuple
  int wK;                   // Index du nom de variable poids
  int lK;                   // Index du nom de variable label (affiche en texte)
  double wMin, wMax;        // Valeurs de poids min/max
  int nWbins;               // Nombre de bins pour le poids (Wt)

};

#endif




